define('bitbucket/internal/util/history', [
    'jquery',
    'bitbucket/util/events',
    'bitbucket/internal/util/browser-window',
    'bitbucket/internal/util/deprecation',
    'bitbucket/internal/util/navigator'
], function (
    $,
    events,
    window,
    deprecation,
    nav
) {
    'use strict';

    var titleSuffix = '';

    function maybeSetTitle(title) {
        if (title) {
            window.document.title = title + titleSuffix;
        }
    }

    function trigger(name, event) {
        var oldEvent = "memoir." + name;
        var newEvent = "bitbucket.internal.history." + name;

        deprecation.triggerDeprecated(oldEvent, undefined, event, null, '4.2', '5.0');
        events.trigger(newEvent, undefined, event);
    }

    return {
        pushState: function (state, title, url) {
            window.history.pushState(state, title || '', url || '');
            maybeSetTitle(title);
            trigger('changestate', {state: state});
        },
        replaceState: function (state, title, url) {
            window.history.replaceState(state, title || '', url || '');
            maybeSetTitle(title);
            trigger('changestate', {state: state});
        },
        state: function () {
            return window.history.state;
        },
        initialState: function (state) {
            return window.history.replaceState(state, '', window.location.href);
        },
        setTitleSuffix: function(suffix) {
            titleSuffix = suffix || '';
        },
        init: function () {
            //Safari fires an event on every page load. We want to swallow this event.
            var skipNextPop = nav.isSafari();

            $(window).on('popstate', function (e) {
                var event = e.originalEvent;

                //The initial event in Safari has event.state === null so if the first event has some state
                //then let it through.
                if (event && (!skipNextPop || event.state !== null)) {
                    trigger('popstate', event);
                    trigger('changestate', event);
                }

                if (skipNextPop) {
                    skipNextPop = false;
                }
            });
        }
    };
});
