define(
    'bitbucket/internal/bbui/paged-table',
    ['exports', 'module', 'aui', 'jquery', 'lodash', './javascript-errors', './paged-scrollable'],
    function (exports, module, _aui, _jquery, _lodash, _javascriptErrors, _pagedScrollable) {
        'use strict';

        var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _errors = _interopRequireDefault(_javascriptErrors);

        var _PagedScrollable2 = _interopRequireDefault(_pagedScrollable);

        /**
         * @enum {string}
         */
        var FocusDirection = {
            NEXT: 'next',
            PREVIOUS: 'prev'
        };

        var PagedTable = (function (_PagedScrollable) {
            _inherits(PagedTable, _PagedScrollable);

            /**
             * An abstract widget used for tables that wish to handle scroll events and load new rows as the user nears the edge of the page.
             *
             * Support is provided for tables that start with some row content already - the initial count of rows is used as the
             * start of the first page of rows to request.
             *
             * It is assumed sub-classes will want to allow navigation of rows and provision is made for this however it is not
             * strictly necessary for sub-classes to implement.
             *
             * To extend PagedTable, you must implement:
             * this.buildUrl(start, limit) : this must build a URL to retrieve the next page of row data
             * this.handleNewRows(data, attachmentMethod) : given a RestPage object and an attachmentMethod ('prepend', 'append', or 'html'),
             * should add new rows to the table
             * this.handleErrors(errors) : should display something appropriate in response to the errors encountered when retrieving new row data
             *
             * You must also supply the following options for which there are no defaults:
             *  - tableMessageClass - the custom CSS class for the element used to display table messages
             *  - allFetchedMessageHtml - the message shown when all rows have been fetched
             *  - noneFoundMessageHtml - the message shown when there were no rows to display
             *
             * You may wish to supply the following options to override defaults:
             *  - ajaxDataType (defaults to 'json') - the data type of the ajax response
             *  - rowSelector (defaults to '> tbody > tr') - allows other elements (such as lists) to be used instead of an actual HTML table
             *
             *  @param {Object} options
             *  @param {HTMLElement|jQuery} options.tableEl - the target `<table>`
             *  @param {boolean} options.filterable - whether the table is filterable
             *  @param {HTMLElement|jQuery?} options.filterEl - the linked filter, if any. If filterable is set and a
             *         filter isn't provided, one will be added to the DOM above the table.
             *  @param {number?} options.filterDebounce - how long to wait before updating the filter
             *  @param {string?} options.scrollPaneSelector
             *  @param {PagedDataProvider} options.dataProvider
             *  @param
             */

            function PagedTable() {
                var _this = this;

                var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

                _classCallCheck(this, PagedTable);

                _get(Object.getPrototypeOf(PagedTable.prototype), 'constructor', this).call(this, options);
                this.$table = (0, _$['default'])(this.options.tableEl);

                if (this.options.filterable) {
                    var tableId = this.$table.attr('id');
                    if (!tableId) {
                        tableId = _2['default'].uniqueId('paged-table-');
                        this.$table.attr('id', tableId);
                    }

                    if (this.options.filterEl) {
                        this.$filter = (0, _$['default'])(this.options.filterEl);
                    } else {
                        this.$filter = (0, _$['default'])(bitbucket.internal.component.pagedTable.filter({
                            forId: tableId,
                            filter: this.provider.filter
                        }));
                        this.$filter.insertBefore(this.$table);
                    }

                    var onFilterChanged = _2['default'].debounce(this._onFilterChanged, this.options.filterDebounce);
                    this.$filter.on('keyup.paged-table-filter', function (e) {
                        if (e.which === _AJS['default'].keyCode.ESCAPE) {
                            (0, _$['default'])(_this).blur();
                        } else {
                            onFilterChanged(e);
                        }
                    }).on('paste.paged-table-filter', onFilterChanged);
                }

                this.$spinner = (0, _$['default'])(bitbucket.internal.component.pagedTable.spinner()).insertAfter(this.$table);
                this.provider.on('data-requested', function () {
                    _this.$spinner.removeClass('hidden').spin(_this.options.spinnerSize);
                });

                var delayedHideSpinner = _2['default'].debounce(function () {
                    _this.$spinner.addClass('hidden').spinStop();
                }, 0);

                this.provider.on('data-loaded', delayedHideSpinner);
                this.provider.on('data-request-failed', delayedHideSpinner);
            }

            /**
             * @type {Object} defaults
             * @property {string} spinnerSize - the size of the spinner
             * @property {boolean} filterable - should the paged table be filterable?
             * @property {number} bufferPixels - the buffer from the bottom/top of the list at which new content gets loaded
             * @property {number} filterDebounce - time in ms for the filter search debounce callback
             * @property {string} rowSelector - the selector that represents a row in the paged table
             * @property {string} rowKeySelector - the key element selector that represents a row (i.e. the rightmost part of rowSelector)
             * @property {Object} focusOptions
             * @property {string} focusOptions.focusedClass - the CSS class to use on the focused row
             * @property {boolean} focusOptions.wrapAround - should the focus wrap around?
             * @property {string} focusOptions.itemLinkSelector - the selector that represents the link to an item in the row
             */
            return PagedTable;
        })(_PagedScrollable2['default']);

        PagedTable.defaults = {
            spinnerSize: 'large',
            filterable: false,
            bufferPixels: 150,
            filterDebounce: 350,
            rowSelector: '> tbody > tr',
            rowKeySelector: 'tr',
            focusOptions: {
                focusedClass: 'focused',
                wrapAround: false,
                itemLinkSelector: '.title a'
            },
            isFiltered: function isFiltered(pagedTable) {
                var filterText = pagedTable.getFilterText();
                return pagedTable.options.filterable && filterText && filterText.length;
            }
        };

        PagedTable.prototype.init = function () {
            var _this2 = this;

            return _PagedScrollable2['default'].prototype.init.apply(this, arguments).done(function () {
                if (_this2.shortcutsInitialised) {
                    _this2.focusInitialRow();
                }
            });
        };

        PagedTable.prototype.getFilterText = function () {
            return this.provider.filter.term;
        };

        PagedTable.prototype._onFilterChanged = function () {
            var term = _$['default'].trim(this.$filter.val());
            if (term !== this.provider.filter.term) {
                this.provider.setFilter('term', term);
                this.provider.reset();
            }
        };

        PagedTable.prototype.reset = function () {
            _PagedScrollable2['default'].prototype.reset.call(this);
            this.$table.addClass('no-rows');
        };

        PagedTable.prototype.update = function (options) {
            this.reset();
            return this.init(options);
        };

        PagedTable.prototype.attachNewContent = function (data) {
            if (data.length) {
                this.handleNewRows(data);
                this._$rows = this.$table.find(this.options.rowSelector);
                if (this.provider.reachedEnd) {
                    this.handleLastPage();
                }
                this.$table.removeClass('no-rows');
            } else {
                if (this.provider.reachedEnd) {
                    // if the first page has no PRs
                    if (this._page === 0) {
                        this.handleNoData();
                    } else {
                        // otherwise must be the last page, so no more pull requests.
                        this.handleLastPage();
                    }
                }
            }

            // Once we have finished manipulating update the timestamp.
            this.updateTimestamp();
        };

        /**
         * Modify the last updated timestamp. This should be called after any modification to the
         * table is made. This is useful when writing browser tests
         */
        PagedTable.prototype.updateTimestamp = function () {
            this.$table.attr('data-last-updated', new Date().getTime());
        };

        /**
         * Implement if rows can be focused and keyboard shortcuts allow focus navigation
         */
        PagedTable.prototype.focusInitialRow = function () {
            this.$table.find(this.options.rowSelector).first().addClass(this.options.focusOptions.focusedClass);
        };

        /**
         * Override if keyboard shortcuts are required but be sure to call this method afterwards
         */
        PagedTable.prototype.initShortcuts = function () {
            this.shortcutsInitialised = true;
            this.focusInitialRow(); //initShortcuts is called after init, so we need to manually call this the first time.
            return {
                destroy: this.resetShortcuts.bind(this)
            };
        };

        /**
         *
         * Get the currently focused item in the table.
         * @returns {jQuery}
         * @private
         */
        PagedTable.prototype._getFocusedItem = function () {
            return this.$table.find(this.options.rowSelector + '.' + this.options.focusOptions.focusedClass);
        };

        /**
         * Open the currently focused item using the focusOptions itemLinkSelector
         */
        PagedTable.prototype.openItem = function () {
            var $focusedItem = this._getFocusedItem();
            if ($focusedItem.length) {
                $focusedItem.find(this.options.focusOptions.itemLinkSelector).get(0).click();
            }
        };

        /**
         * Move the focus to the previous or next row and scroll the focused item in to view if needed
         *
         * @param {FocusDirection} direction - the direction to move
         */
        PagedTable.prototype._moveFocus = function (direction) {
            var $focusedItem = this._getFocusedItem();
            var $next = $focusedItem[direction](this.options.rowKeySelector);

            // if we need to wrap around, check if the current item is the first/last item in the list (depending on direction)
            if (this.options.focusOptions.wrapAround) {
                // check if we need to go the first or last item
                if (direction === FocusDirection.NEXT && $focusedItem.is(this._$rows.last())) {
                    $next = this._$rows.first();
                }
                if (direction === FocusDirection.PREVIOUS && $focusedItem.is(this._$rows.first())) {
                    $next = this._$rows.last();
                }
            }

            if ($focusedItem.length && $next.length) {
                // set focus on the next item and unfocus the previously focused one
                $next.addClass(this.options.focusOptions.focusedClass);
                $focusedItem.removeClass(this.options.focusOptions.focusedClass);

                // Scroll in to view if needed.
                // Check if the $next item is above the upper bound or below the lower bound of
                // the scroll pane's visible area
                var topBound = this.$scrollElement.scrollTop();
                var bottomBound = this.$scrollElement.scrollTop() + this.$scrollElement.height();
                var isOutOfTopBound = $next.offset().top < topBound;
                var isOutOfBottomBound = $next.offset().top + $next.height() > bottomBound;
                if (isOutOfTopBound || isOutOfBottomBound) {
                    // align to the bottom when moving up and the top when moving down
                    // pass in isOutOfBottomBound as the "alignToTop" boolean because the focused item scrolled in
                    // to view should align to the top when the focus has moved passed the bottom of the page
                    $next.get(0).scrollIntoView(isOutOfBottomBound);
                }
            }
        };

        /**
         * Move focus to the next row
         */
        PagedTable.prototype.moveNext = function () {
            this._moveFocus(FocusDirection.NEXT);
        };

        /**
         * Move focus to the previous row
         */
        PagedTable.prototype.movePrevious = function () {
            this._moveFocus(FocusDirection.PREVIOUS);
        };

        PagedTable.prototype.resetShortcuts = function () {
            this.shortcutsInitialised = false;
        };

        PagedTable.prototype._new$Message = function (content) {
            if (content) {
                return bitbucket.internal.component.pagedTable.message({
                    content: content,
                    extraClasses: this.options.tableMessageClass
                });
            }
        };

        PagedTable.prototype.handleLastPage = function () {
            this.$table.after(this._new$Message(this.options.allFetchedMessageHtml));
        };

        PagedTable.prototype.handleNoData = function () {
            var messageHtml = this.options.isFiltered(this) ? this.options.noneMatchingMessageHtml : this.options.noneFoundMessageHtml;

            this.$table.addClass('no-rows').after(this._new$Message(messageHtml));
        };

        /**
         * Given an array of Errors, display appropriate error messaging for your implementation.
         * @param {Array<Error>} errors
         * @abstract
         */
        PagedTable.prototype.handleErrors = function (errors) {
            throw new errors.NotImplementedError();
        };

        /**
         *
         * @param {Object} data
         * @abstract
         */
        PagedTable.prototype.handleNewRows = function (data) {
            throw new _errors['default'].NotImplementedError();
        };

        PagedTable.prototype.clear = function () {
            this.$table.children('tbody').empty();
            this.$table.addClass('no-rows').nextAll('.paged-table-message').remove();
        };

        module.exports = PagedTable;
    }
);