define(
    'bitbucket/internal/bbui/mirroring-admin',
    ['exports', 'module', 'aui', 'aui/flag', 'jquery', 'lodash', 'bitbucket/internal/impl/request', 'bitbucket/internal/impl/urls', './list-and-detail-view', './mirroring-admin/mirror-view/mirror-view', './mirroring-admin/nav-builder', './mirroring-admin/request-view/request-view', './widget'],
    function (exports, module, _aui, _auiFlag, _jquery, _lodash, _bitbucketInternalImplRequest, _bitbucketInternalImplUrls, _listAndDetailView, _mirrorViewMirrorView, _navBuilder, _requestViewRequestView, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _auiFlag2 = _interopRequireDefault(_auiFlag);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _ajax = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _ListAndDetailView = _interopRequireDefault(_listAndDetailView);

        var _MirrorView = _interopRequireDefault(_mirrorViewMirrorView);

        var _nav = _interopRequireDefault(_navBuilder);

        var _RequestView = _interopRequireDefault(_requestViewRequestView);

        var _Widget2 = _interopRequireDefault(_widget);

        /**
         * @typedef MirrorRequest
         * @type {object}
         * @param {string} id           - the request's id
         * @param {string} mirrorName   - the requesting mirror's name
         */

        /**
         * @typedef Mirror
         * @type {object}
         * @param {string} id   - the mirror's id
         * @param {string} name - the mirror's name
         */

        /**
         * Determines if the object contains only undefined or empty child objects
         * @param value
         * @return {boolean} true if all child nodes are undefined, false otherwise
         */
        function isEmpty(value) {
            return _2['default'].isEmpty(value) || !_2['default'].any(value, function (value) {
                return !_2['default'].isEmpty(value);
            });
        }

        /**
         * Log a warning message when the list failed to refresh.
         * @param {object} response - the AJAX response object
         */
        function failedToRefresh(response) {
            var errorMessage = response.responseJSON.errors.map(function (obj) {
                return obj.message;
            }).join('');
            console.warn('Failed to refresh list. Error: ' + errorMessage);
        }

        var MirroringAdmin = (function (_Widget) {
            _inherits(MirroringAdmin, _Widget);

            /**
             * Control for the entire mirroring admin UI panel.
             * @param {HTMLElement} el - the element the UI panel is to be contained in
             * @param {object} options
             * @param {Array<Mirror>}        [options.mirrors]              - the mirrors to show in the list
             * @param {Array<MirrorRequest>} [options.requests]             - the mirroring requests to show in the list
             * @param {boolean}              [options.unavailable]          - indicates if the feature is available
             * @param {string}               [options.unavailableMessage]   - an i18n'd string to add to the empty state if the
             *                                                                feature is not available. May not contain HTML.
             * @param {int}                  [options.refreshInterval]      - the number of ms at which to poll for new mirrors
             *                                                                and requests
             */

            function MirroringAdmin(el, options) {
                var _this = this;

                _classCallCheck(this, MirroringAdmin);

                _get(Object.getPrototypeOf(MirroringAdmin.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);

                if (this.options.unavailable) {
                    this.$el.html(bitbucket.internal.component.mirroringAdmin.main({
                        isEmpty: true,
                        unavailableText: _AJS['default'].escapeHtml(this.options.unavailableMessage)
                    }));
                } else {
                    this.navListItems = {
                        mirror: {},
                        request: {}
                    };
                    this.options.requests.forEach(function (item) {
                        return _this.addToNavListItems(item, 'request');
                    });
                    this.options.mirrors.forEach(function (item) {
                        return _this.addToNavListItems(item, 'mirror');
                    });

                    this.$el.html(bitbucket.internal.component.mirroringAdmin.main({ isEmpty: isEmpty(this.navListItems) }));

                    this.listAndDetailView = new _ListAndDetailView['default'](this.$el.find('.mirroring-admin'), {
                        selectHandler: this.itemSelectedHandler,
                        selectFirstOnInit: true,
                        selectedClass: 'selected-item',
                        listContent: bitbucket.internal.component.mirroringAdmin.navbar({
                            mirrors: this.options.mirrors,
                            requests: this.options.requests
                        })
                    });

                    if (this.options.refreshInterval) {
                        this.interval = setInterval(this.refreshList, this.options.refreshInterval);
                    }
                }
            }

            _createClass(MirroringAdmin, [{
                key: 'destroy',
                value: function destroy() {
                    clearInterval(this.interval);
                    _get(Object.getPrototypeOf(MirroringAdmin.prototype), 'destroy', this).call(this);
                    this.$el.empty();
                    this.$el = null;
                }
            }, {
                key: 'addToNavListItems',
                value: function addToNavListItems(item, type) {
                    this.navListItems[type][item.id] = item;
                }
            }, {
                key: 'itemSelectedHandler',
                value: function itemSelectedHandler($selectedItem, $listView, $detailView, e) {
                    var type = $selectedItem.attr('data-type');
                    var id = $selectedItem.attr('data-id');
                    var viewData = { item: this.navListItems[type][id] };
                    if (!viewData.item) {
                        return;
                    }

                    if (this.currentView) {
                        this.currentView.destroy();
                    }

                    var ViewClass = this.options.views[type];
                    if (ViewClass) {
                        this.currentView = new ViewClass($detailView, viewData);
                        if (type === 'request') {
                            this.currentView.on('request-resolved', this.transitionItem);
                        } else if (type === 'mirror') {
                            this.currentView.on('mirror-removed', this.removeItem);
                        }
                    } else {
                        throw new Error('Invalid view type \'' + type + '\'');
                    }
                }

                /**
                 * Finds the element which to insert the given item before
                 * @returns {jQuery|HTMLElement} the element which to insert the given item before
                 */
            }, {
                key: 'findBeforeElement',
                value: function findBeforeElement() {
                    var $mirrors = this.listAndDetailView.$listView.find('.mirror'); // includes mirror-request items as well
                    return $mirrors.length ? $mirrors[0] : (0, _$['default'])('#learn-more-mirroring');
                }

                /**
                 * Remove an item from the listView.
                 * @param {RequestResolvedObject} options
                 */
            }, {
                key: 'removeItem',
                value: function removeItem(options) {
                    delete this.navListItems[options.type][options.id];
                    var $item = this.listAndDetailView.$listView.find('[data-id="' + options.id + '"][data-type="' + options.type + '"]');
                    this.listAndDetailView.removeItem($item, '.mirror');
                    this.updateEmptyState();
                }

                /**
                 * Refreshes the listView.
                 * Calls the REST endpoint and updates the listView accordingly.
                 */
            }, {
                key: 'refreshList',
                value: function refreshList() {
                    var _this2 = this;

                    if (this.refreshPromise) {
                        return;
                    }

                    var requestsPromise = _ajax['default'].rest({
                        type: 'GET',
                        url: _nav['default'].rest().mirroring().path('requests').params({ state: 'pending' }).build(),
                        statusCode: {
                            '*': false
                        }
                    });

                    var mirrorsPromise = _ajax['default'].rest({
                        type: 'GET',
                        url: _nav['default'].rest().mirroring().path('mirrorServers').build(),
                        statusCode: {
                            '*': false
                        }
                    });

                    var handleItem = function handleItem(item, type, template) {
                        if (!_this2.navListItems[type] || !_this2.navListItems[type][item.id]) {
                            var selectItem = !_2['default'].some(_this2.navListItems, _2['default'].size);
                            _this2.addToNavListItems(item, type);
                            _this2.listAndDetailView.addItem((0, _$['default'])(template(_defineProperty({}, type, item))), _this2.findBeforeElement(), selectItem);
                        }
                    };

                    _AJS['default'].$('.list-refresh-spinner').spin();

                    this.refreshPromise = _$['default'].when(requestsPromise, mirrorsPromise);
                    this.refreshPromise.always(function () {
                        _AJS['default'].$('.list-refresh-spinner').spinStop();
                        _this2.refreshPromise = null;
                    }).done(function (requestPage, mirrorPage) {
                        requestPage[0].values.forEach(function (item) {
                            handleItem(item, 'request', bitbucket.internal.component.mirroringAdmin.mirrorRequestNavItem);
                        });
                        mirrorPage[0].values.forEach(function (item) {
                            handleItem(item, 'mirror', bitbucket.internal.component.mirroringAdmin.mirrorNavItem);
                        });
                        _this2.updateEmptyState();
                    }).fail(failedToRefresh);
                }

                /**
                 * Hides or shows the empty state,
                 * depending on if there are mirroring requests/mirrors to show.
                 */
            }, {
                key: 'updateEmptyState',
                value: function updateEmptyState() {
                    var empty = isEmpty(this.navListItems);
                    (0, _$['default'])('.mirroring-admin').toggleClass('hidden', empty);
                    (0, _$['default'])('.empty-state').toggleClass('hidden', !empty);
                }

                /**
                 * Transitions an item based on the item's resolution
                 * Deleted items are removed, accepted items are transitioned.
                 * @param {RequestResolvedObject} options
                 */
            }, {
                key: 'transitionItem',
                value: function transitionItem(options) {
                    switch (options.resolution) {
                        case 'accept':
                            var $item = this.transformToMirror(options);
                            $item.click();
                            break;
                        case 'reject':
                            this.removeItem(options);
                            break;
                    }
                    this.updateEmptyState();
                }

                /**
                 * Transforms an existing mirroring nav item into a mirror nav item.
                 * @param {RequestResolvedObject} options
                 * @return {jQuery} the transformed nav item
                 */
            }, {
                key: 'transformToMirror',
                value: function transformToMirror(options) {
                    delete this.navListItems[options.type][options.id];
                    var mirror = options.responseJSON;
                    this.addToNavListItems(mirror, 'mirror');
                    var $item = this.listAndDetailView.$listView.find('[data-id="' + options.id + '"][data-type="' + options.type + '"]');
                    $item.removeClass('mirror-request');
                    $item.attr('data-id', mirror.id);
                    $item.attr('data-type', 'mirror');

                    $item.find('.status-container').append(bitbucket.internal.component.mirroringAdmin.mirrorStatus({ status: mirror.state }));

                    var $statuses = $item.find('.status');
                    var transitionClass = 'transitioning';
                    $statuses.one('transitionend', function () {
                        $statuses.last().removeClass(transitionClass);
                        $statuses.first().remove();
                    }).addClass(transitionClass);

                    return $item;
                }
            }]);

            return MirroringAdmin;
        })(_Widget2['default']);

        module.exports = MirroringAdmin;

        MirroringAdmin.defaults = {
            mirrors: [],
            requests: [],
            refreshInterval: 0, //Polling is _disabled_ by default.
            unavailable: false,
            unavailableMessage: '',
            views: {
                mirror: _MirrorView['default'],
                request: _RequestView['default']
            }
        };
    }
);