define(
    'bitbucket/internal/bbui/mirroring-admin/mirror-view/mirror-view',
    ['exports', 'module', 'aui', 'aui/flag', 'jquery', 'lodash', 'bitbucket/internal/impl/request', '../nav-builder', '../../widget'],
    function (exports, module, _aui, _auiFlag, _jquery, _lodash, _bitbucketInternalImplRequest, _navBuilder, _widget) {
        'use strict';

        var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _auiFlag2 = _interopRequireDefault(_auiFlag);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _ajax = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _nav = _interopRequireDefault(_navBuilder);

        var _Widget2 = _interopRequireDefault(_widget);

        /*global window*/

        /**
         * Ensure the connect JS resources are on the page.
         *
         * The connect JS resources will not be on the page if an add-on is not installed when the page is loaded (e.g. there are
         * no mirrors). This is a problem when adding the first mirror (aka the first add-on) as these resources are needed
         * to display the config webpanel from the mirror. To get around this we always do a WRM call to ensure the resources
         * are on the page.
         *
         * @return {Promise} called when the resource is on the page.
         */

        function includeConnect() {
            if (window.WRM && window.WRM.require) {
                return window.WRM.require("wr!com.atlassian.plugins.atlassian-connect-plugin:bitbucket-atlassian-connect-resources");
            } else {
                //Assume they are already on the page.
                return _$['default'].when();
            }
        }

        /**
         * @typedef {Object} Mirror
         * @property {string} name      - the Mirror's name
         * @property {string} baseUrl   - the Mirror's base URL
         */

        /**
         * @typedef {Object} ViewData
         * @property {Mirror} item - the Mirror the view should display
         */

        var MirrorView = (function (_Widget) {
            _inherits(MirrorView, _Widget);

            /**
             * @param {jQuery| HTMLElement} el      - the container element for this component
             * @param {ViewData}            options - the Mirror this component shows information for
             */

            function MirrorView(el, options) {
                _classCallCheck(this, MirrorView);

                _get(Object.getPrototypeOf(MirrorView.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);
                this.$el.html(bitbucket.internal.component.mirroringAdmin.mirrorView.main(options));
                this.$panel = this.$el.find("#mirror-details-panel");
                this.mirror = this.options.item;
                this.init();
            }

            _createClass(MirrorView, [{
                key: 'destroy',
                value: function destroy() {
                    _get(Object.getPrototypeOf(MirrorView.prototype), 'destroy', this).call(this);
                    if (this.loadingPanelRequest) {
                        this.loadingPanelRequest.abort();
                        delete this.loadingPanelRequest;
                    }
                    this._cancelLoadingTimer();
                    this.$el.empty();
                    delete this.$el;
                }
            }, {
                key: 'init',
                value: function init() {
                    var _this = this;

                    (0, _$['default'])('#mirror-remove-button').on('click', this.showRemoveMirrorDialog);
                    this.$panel.on('click', "#mirror-reload", function (e) {
                        e.preventDefault();
                        _this.showMirrorPanel();
                    });
                    this.showMirrorPanel();
                }

                /**
                 * Shows a confirmation dialog before removing the mirror.
                 */
            }, {
                key: 'showRemoveMirrorDialog',
                value: function showRemoveMirrorDialog() {
                    var _this2 = this;

                    var $dialogEl = (0, _$['default'])(bitbucket.internal.component.mirroringAdmin.mirrorView.deleteDialog({
                        mirrorName: this.mirror.name
                    }));
                    this.$el.append($dialogEl);

                    var dialog = _AJS['default'].dialog2('#delete-mirror-dialog');

                    dialog.on('hide', function () {
                        $dialogEl.remove();
                    });

                    $dialogEl.find('#dialog-delete-button').click(function () {
                        _this2.removeMirror();
                        dialog.hide();
                    });

                    $dialogEl.find('#dialog-cancel-button').click(function () {
                        return dialog.hide();
                    });

                    dialog.show();
                }
            }, {
                key: 'showMirrorPanel',
                value: function showMirrorPanel() {
                    var _this3 = this;

                    this._delayShowLoadingSpinner();
                    this.loadingPanelRequest = _ajax['default'].rest({
                        type: 'GET',
                        dataType: 'html',
                        url: _nav['default'].rest().mirroring().panel(this.mirror.id).build(),
                        statusCode: {
                            '*': false
                        }
                    });
                    _$['default'].when(this.loadingPanelRequest, includeConnect()).always(function () {
                        _this3._hideLoadingSpinner();
                        delete _this3.loadingPanelRequest;
                    }).done(function (_ref) {
                        var _ref2 = _slicedToArray(_ref, 1);

                        var html = _ref2[0];

                        _this3.$panel.html(html);
                    }).fail(function (xhr, status) {
                        if (status !== 'abort') {
                            _this3._renderErrorView();
                        }
                    });
                }

                /**
                 * Removes the current mirror from the upstream.
                 */
            }, {
                key: 'removeMirror',
                value: function removeMirror() {
                    var _this4 = this;

                    MirrorView._showRemoveSpinner();
                    _ajax['default'].rest({
                        type: 'DELETE',
                        url: _nav['default'].rest().mirroring().path('mirrorServers', this.mirror.id).build(),
                        statusCode: {
                            '409': false
                        }
                    }).done(function (response) {
                        _this4._removeMirrorSuccessful();

                        /**
                         * A mirror removed event object.
                         * @typedef {Object} MirrorRemoved
                         * @property {string}   id            - The ID of the mirror that was removed
                         * @property {string}   type          - The type to remove. Always 'mirror' here.
                         * @property {JSON}     responseJSON  - The JSON returned by the REST request.
                         */
                        _this4.trigger('mirror-removed', {
                            id: _this4.mirror.id,
                            type: 'mirror',
                            responseJSON: response
                        });
                    }).fail(function (response) {
                        var errors = _2['default'].get(response, 'responseJSON.errors');
                        if (errors) {
                            // one of our REST errors
                            return _this4._removeMirrorFailed(errors);
                        }
                        throw response; // some other error; Bubble it up.
                    }).always(MirrorView._stopRemoveSpinner);
                }

                /**
                 * Show an AUI Error Flag with the error details
                 * @param {Array<String>} errors
                 * @private
                 */
            }, {
                key: '_removeMirrorFailed',
                value: function _removeMirrorFailed(errors) {
                    (0, _auiFlag2['default'])({
                        type: 'error',
                        title: _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.mirror.remove.failure', this.mirror.name),
                        body: errors.map(function (error) {
                            return _AJS['default'].escapeHtml(error.message);
                        }).join(',')
                    });
                }

                /**
                 * Show an AUI Success Flag
                 * @private
                 */
            }, {
                key: '_removeMirrorSuccessful',
                value: function _removeMirrorSuccessful() {
                    (0, _auiFlag2['default'])({
                        type: 'success',
                        title: _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.mirror.remove.success', this.mirror.name),
                        persistent: false,
                        close: 'auto',
                        body: ''
                    });
                }
            }, {
                key: '_renderErrorView',
                value: function _renderErrorView() {
                    this.$panel.html(bitbucket.internal.component.mirroringAdmin.mirrorView.mirrorConnectionError());
                }
            }, {
                key: '_delayShowLoadingSpinner',
                value: function _delayShowLoadingSpinner() {
                    var _this5 = this;

                    this.loadingSpinnerTimer = window.setTimeout(function () {
                        _this5.$panel.html(bitbucket.internal.component.mirroringAdmin.mirrorView.loading());
                        _this5.$panel.find('#mirror-loading').spin('large');
                        delete _this5.loadingSpinnerTimer;
                    }, 500);
                }
            }, {
                key: '_hideLoadingSpinner',
                value: function _hideLoadingSpinner() {
                    this.$panel.find('#mirror-loading').spinStop();
                    this._cancelLoadingTimer();
                }
            }, {
                key: '_cancelLoadingTimer',
                value: function _cancelLoadingTimer() {
                    if (_2['default'].isNumber(this.loadingSpinnerTimer)) {
                        window.clearTimeout(this.loadingSpinnerTimer);
                        delete this.loadingSpinnerTimer;
                    }
                }
            }], [{
                key: '_showRemoveSpinner',
                value: function _showRemoveSpinner() {
                    (0, _$['default'])('#mirror-remove-button').addClass('hidden');
                    (0, _$['default'])('#mirror-remove-button-spinner').removeClass('hidden').spin();
                }
            }, {
                key: '_stopRemoveSpinner',
                value: function _stopRemoveSpinner() {
                    (0, _$['default'])('#mirror-remove-button').removeClass('hidden');
                    (0, _$['default'])('#mirror-remove-button-spinner').addClass('hidden').spinStop();
                }
            }]);

            return MirrorView;
        })(_Widget2['default']);

        module.exports = MirrorView;
    }
);