define(
    'bitbucket/internal/bbui/codesearch/internal/search',
    ['exports', 'jquery', 'lodash', 'bitbucket/internal/impl/search-urls', 'bitbucket/internal/impl/request', './search-data-provider', './search-entities', './search-results-table'],
    function (exports, _jquery, _lodash, _bitbucketInternalImplSearchUrls, _bitbucketInternalImplRequest, _searchDataProvider, _searchEntities, _searchResultsTable) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _searchUrls = _interopRequireDefault(_bitbucketInternalImplSearchUrls);

        var _request = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _SearchDataProvider = _interopRequireDefault(_searchDataProvider);

        var _SearchEntities = _interopRequireDefault(_searchEntities);

        var _SearchResultsTable = _interopRequireDefault(_searchResultsTable);

        /**
         * Given a SearchRequest object, perform a search.
         * @param {Object} searchRequest
         * @returns {Promise} request promise
         */
        function search(searchRequest) {
            return _request['default'].rest({
                type: 'POST',
                url: _searchUrls['default'].searchRestUrl(),
                data: searchRequest
            });
        }

        /**
         * Sets up and creates the search result UI within an element, with an initial query.
         * @param {jQuery|HTMLElement} el
         * @param {String} query
         * @returns {Promise} Promise that resolves when the initial search completes
         */
        function createSearch(el, query) {
            // setup search data provider for query
            var $el = (0, _$['default'])(el);
            $el.empty(); // also unbinds event handlers

            // show the 'searching' spinner while we do the initial search
            $el.html(bitbucket.internal.component.codesearch.searching());
            var $searching = $el.find('.code-search-searching');
            $searching.find('.spin-container').spin();

            // perform initial search
            return search({
                query: query
            }).then(function (initialResults) {
                $searching.remove();

                // setup SearchResultsTable for primary results
                var primaryResultType = _2['default'].findKey(initialResults, { category: 'primary' });
                var primaryResult = initialResults[primaryResultType];
                var dataProvider = new _SearchDataProvider['default']({
                    query: query,
                    search: search,
                    type: primaryResultType
                }, initialResults);

                var repository = initialResults.scope.repository;
                var project = repository ? repository.project : initialResults.scope.project;
                $el.html(bitbucket.internal.component.codesearch.results({
                    count: primaryResult.count,
                    repository: repository,
                    project: project
                }));

                var searchResults = new _SearchResultsTable['default']($el.find('.primary-results'), {
                    dataProvider: dataProvider
                });
                searchResults.init();
                return searchResults;
            });

            // TODO render secondary results
        }

        exports.createSearch = createSearch;
        exports.search = search;
    }
);