(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/paged-data-provider', 'bitbucket/internal/models', 'bitbucket/internal/json-validation', 'lodash'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/spi/data-provider/pull-request-list', ['exports', 'module', 'bitbucket/internal/paged-data-provider', 'bitbucket/internal/models', 'bitbucket/internal/json-validation', 'lodash'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var PagedDataProvider = require("bitbucket/internal/paged-data-provider");
var models = require("bitbucket/internal/models");
var validator = require("bitbucket/internal/json-validation");
var _ = require("lodash");

var PullRequestListDataProvider = (function (_PagedDataProvider) {
    function PullRequestListDataProvider() {
        var _get2;

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
        }

        var options = arguments[0] === undefined ? {} : arguments[0];

        _classCallCheck(this, PullRequestListDataProvider);

        /**
         * We extend the pull_request model with commentCount and taskCount
         */
        options.jsonDescriptor = [_.extend({}, models.pull_request, {
            commentCount: "number?",
            taskCount: "number?"
        })];

        /**
         * @type {Object}
         * @property {string?} author_id - the author's username
         * @property {string?} target_ref_id - the ref string, e.g. refs/heads/
         * @property {string?} reviewer_id - the reviewer's username
         * @property {models.PullRequestState?} state
         */
        options.filterDescriptor = {
            author_id: "string?",
            target_ref_id: "string?",
            reviewer_id: "string?",
            state: validator.asEnum("PullRequestState", models.PullRequestState)
        };
        (_get2 = _get(Object.getPrototypeOf(PullRequestListDataProvider.prototype), "constructor", this)).call.apply(_get2, [this, options].concat(args));
    }

    _inherits(PullRequestListDataProvider, _PagedDataProvider);

    return PullRequestListDataProvider;
})(PagedDataProvider);

module.exports = PullRequestListDataProvider;

});
