(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/javascript-errors', 'bitbucket/internal/data-provider', 'bitbucket/internal/json-validation', 'jquery'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/spi/paged-data-provider', ['exports', 'module', 'bitbucket/internal/javascript-errors', 'bitbucket/internal/data-provider', 'bitbucket/internal/json-validation', 'jquery'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var errors = require("bitbucket/internal/javascript-errors");
var DataProvider = require("bitbucket/internal/data-provider");
var validator = require("bitbucket/internal/json-validation");
var $ = require("jquery");

var PagedDataProvider = (function (_DataProvider) {

    /**
     * @param {Object?} options - The options for the Data Provider
     * @param {Object?} options.filter - a set of parameters to filter the DataProvider
     * @param {?Object} initialData - The initial data for this provider
     */

    function PagedDataProvider() {
        var _get2;

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
        }

        var options = arguments[0] === undefined ? {} : arguments[0];

        _classCallCheck(this, PagedDataProvider);

        (_get2 = _get(Object.getPrototypeOf(PagedDataProvider.prototype), "constructor", this)).call.apply(_get2, [this, options].concat(args));
        // the untransformed last response fetched.
        this._lastPageData = null;

        if (options.filterDescriptor) {
            this._validateFilter = validator(options.filterDescriptor);
        }

        this.filter = options.filter || {};
        this._validateFilter(this.filter);
    }

    _inherits(PagedDataProvider, _DataProvider);

    _createClass(PagedDataProvider, {
        reachedEnd: {

            /**
             * @type {boolean}
             * Whether the data provider has fetched the last page of data yet. Returns false before any data has been fetched.
             */

            get: function () {
                return this._lastPageData ? this._reachedEnd(this._lastPageData) : false;
            }
        },
        _validateFilter: {

            /**
             * Validates that the filter matches the shape expected by a subclass. By default, providers are assumed not to
             * be filterable, and throw if any filter properties are set.
             */

            value: function _validateFilter(f) {
                if (Object.keys(f).length) {
                    throw new Error("No filter is expected on this data-provider.");
                }
            }
        },
        setFilter: {

            /**
             * Set a filter property and reset the data provider
             *
             * @param {string} key
             * @param {*} val
             */

            value: function setFilter(key, val) {
                if (this.filter) {
                    this.filter[key] = val;
                }
                if (this._validateFilter) {
                    this._validateFilter(this.filter);
                }
            }
        },
        fetchNext: {

            /**
             * Fetch the next page of data. Duplicates lot's of logic in `fetch()`, but ignores `currentData` for caching.
             * @returns {Promise} A promise that resolves to the transformed data
             */

            value: function fetchNext() {
                var _this = this;

                if (this.reachedEnd) {
                    throw new Error("Nothing left to fetch.");
                }

                // If a fetch is attempted before the previous fetch has returned,
                // then abort the previous fetch and continue with the new request.
                this.abort();

                // If there is initial data, upgrade the currentData to initialData
                if (this.initialData) {
                    this._lastPageData = this.initialData;
                    this.currentData = this.transform(this.initialData);
                    // initialData is single use, delete it after it has been consumed
                    delete this.initialData;
                    return $.Deferred().resolve(this.currentData);
                }

                this.trigger("data-requested");

                this._requestPromise = this._fetchNext(this._lastPageData);
                if (!this._requestPromise.abort) {
                    throw new Error("no abort method on PagedDataProvider#_requestPromise.");
                }

                this._requestPromise.then(function (page) {
                    return _this._lastPageData = page;
                });
                return this._requestPromise.then(this.transform, function () {
                    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key];
                    }

                    return $.Deferred().reject(_this.errorTransform.apply(_this, args));
                }).done(function (transformedData) {
                    _this.trigger("data-loaded", transformedData);
                    _this.currentData = transformedData;
                }).fail(function (error) {
                    _this.trigger("data-request-failed", error);
                }).always(function () {
                    _this._requestPromise = null;
                });
            }
        },
        reset: {
            value: function reset() {
                this._lastPageData = null;
                _get(Object.getPrototypeOf(PagedDataProvider.prototype), "reset", this).call(this);
            }
        },
        _fetchNext: {

            /**
             * Given the last page retrieved, call `this._fetch(url)` with the correct URL for the next page of data.
             * @param {*} lastPageData - the data returned by the last request, or null if no request has been made
             * @returns {Promise} - must be abortable.
             * @protected
             */

            value: function _fetchNext(lastPageData) {
                throw new errors.NotImplementedError();
            }
        },
        _reachedEnd: {

            /**
             * Whether the data provider has fetched the last page of data yet.
             *
             * @param {*} lastPageData - the data returned by the last request
             * @returns {boolean}
             * @protected
             */

            value: function _reachedEnd(lastPageData) {
                throw new errors.NotImplementedError();
            }
        }
    });

    return PagedDataProvider;
})(DataProvider);

module.exports = PagedDataProvider;

});
