# bitbucket-user-data-provider

> Data provider SPI for user data

## Installation

```
> bower install --save bitbucket-user-data-provider
```

## Usage

Implement a UserDataProvider like:

```js
import UserDataProviderSPI from 'bitbucket/internal/spi/user-data-provider';

export default class UserDataProvider extends UserDataProviderSPI {

    _fetch(url) { // Likely to be implemented in a super class instead of here.
        return $.getJSON(url);
    }

    _reachedEnd(lastResponseData) { // Likely to be implemented in a super class instead of here.
        return !lastResponseData.next;
    }

    _fetchNext(lastResponseData) {
        var url = lastResponseData.next ||
            ('http://example.com/rest/users' + parsePermissionsHowMnyProductLikesThem(this.filter.permissions));
        return this._fetch(url);
    }

    _transform(responseData) {
        return responseData.values.map(makeRef);
    }
}
```

Use one like:

```js
import UserDataProvider from 'bitbucket/internal/user-data-provider';

// KNOWN_USER is superfluous here for demo only - it just means 'not anonymous user'
// REPO_READ here will filter down just users that can read from the repo with id '7'.
var provider = new UserDataProvider({
    filter: {
        permissions: [{ // create a provider filtered to those with the given permission(s)
            name: 'KNOWN_USER'
        }, {
            name: 'REPO_READ',
            repository_id: '7'
        }]
    }
});

function getEverythingFoolishly(allUsers) {
    if (provider.reachedEnd) { // stop when there's no more
        return Promise.resolve(allUsers);
    }

    return provider.fetchNext().then(function(users) { // otherwise get some more
        return getEverythingFoolishly(allUsers.concat(users));
    });
}

getEverythingFoolishly([]);
```

## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt test
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 0.1.0

Initial release
