define('bitbucket/internal/layout/repository', [
    'aui',
    'jquery',
    'lodash',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/feature/repository/sticky-branches',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/model/repository',
    'bitbucket/internal/util/events',
    'bitbucket/internal/widget/quick-copy-text',
    'bitbucket/internal/widget/sidebar',
    'exports'
], function(
    AJS,
    $,
    _,
    nav,
    stickyBranches,
    pageState,
    Repository,
    events,
    quickCopyText,
    sidebar,
    exports
) {

    function initRepositoryPageState(repositoryJson) {
        var repo = new Repository(repositoryJson);
        pageState.setRepository(repo);
        pageState.setProject(repo.getProject());
        // TODO: remove this. It is here for testing if people use the project avatar icon as a button.
        $('.aui-page-header-image > a').on('click', function() {
            events.trigger('bitbucket.internal.sidebar.clickAvatar.expanded.' + $('.aui-sidebar').attr('aria-expanded'), null);
        });
    }

    function getCloneUrlContainer() {
        return $('.clone-url');
    }

    function getCloneUrlProtocolTrigger() {
        return $('.repository-protocol');
    }

    /**
     * Input elements can't be sized to fit their contents, so we have to use a bit of javascript to do it for us.
     * This method creates a fake element to calculate the size of one monospace character and then sets the width
     * of the input element to be input.length * width. There are a few rounding issues on some browsers but should
     * be good enough for the most part.
     *
     * Finally, this method also binds events to focus/mouseup to automatically select the input text for the
     * convenience of the user who is going to want to copy the value.
     */
    function initCloneUrlInput() {
        var $container = getCloneUrlContainer();
        var $cloneInput = $container.find("input");
        var $cloneProtocolTrigger = getCloneUrlProtocolTrigger();
        var $cloneProtocolDropdown = $('#' + $cloneProtocolTrigger.attr("aria-controls"));
        var $cloneProtocolDropdownItems = $cloneProtocolDropdown.find('li');
        var cloneUrl;
        var moduleKey;
        var oldModuleKey = '';

        if($cloneProtocolTrigger.is('button')) {
            updateCloneProtocolTrigger($cloneProtocolTrigger, $cloneProtocolTrigger.text());
            cloneUrl = $cloneProtocolTrigger.attr('data-clone-url');
            moduleKey = $cloneProtocolTrigger.attr('data-module-key');
        } else {
            updateCloneProtocolTrigger($cloneProtocolTrigger, $cloneProtocolDropdownItems.first().children('a').text());
            cloneUrl = $cloneProtocolDropdownItems.first().attr('data-clone-url');
            moduleKey = $cloneProtocolDropdownItems.first().attr('data-module-key');
        }
        $cloneInput.val(cloneUrl);
        $container.addClass(moduleKey);
        oldModuleKey = moduleKey;

        $cloneProtocolDropdownItems.on('click', function(event) {
            var $this = $(this);
            updateCloneProtocolTrigger($cloneProtocolTrigger, $this.text());
            $cloneInput.val($this.attr('data-clone-url')).select();
            moduleKey= $this.attr('data-module-key');
            $container.removeClass(oldModuleKey).addClass(moduleKey);
            oldModuleKey = moduleKey;
            events.trigger('bitbucket.internal.feature.repository.clone.protocol.changed', null, moduleKey, $this.attr('data-clone-url'));

            // the dropdown is outside of the inline dialog, so clicking on a dropdown item actually hides the inline
            // dialog, so we prevent that from happening...
            event.stopPropagation();
            if ($cloneProtocolDropdown.is(':visible')) { // but we still want to hide the dropdown onclick if it is visible
                $cloneProtocolTrigger.trigger("aui-button-invoke");
            }
            event.preventDefault();
        });

        events.trigger('bitbucket.internal.feature.repository.clone.protocol.initial', null, moduleKey, cloneUrl);

    }

    function updateCloneProtocolTrigger(trigger, newLabel) {
        var $cloneProtocolLabel = trigger.children('span').remove(); // pull the icon span element out and store it temporarily
        trigger.text(newLabel).append($cloneProtocolLabel); // replace the dropdown trigger text and add the icon span back in
    }

    function initCloneUrlDialog(cloneUrlDialogTrigger, cloneUrlDialogContent) {
        var $dialogContent = $(cloneUrlDialogContent);
        var dialogPos = null;
        var arrowPos = null;

        var dialog = AJS.InlineDialog(null, "clone-repo-dialog", function (content, trigger, showPopup) {
            content.append($dialogContent);
            showPopup();
            //I'm so sorry :(
            //This is trying to mimic what looks like 2 setTimeout(fn, 0)s in InlineDialog.
            //We should really move to InlineDialog2
            _.defer(function() {
                _.defer(function () {
                    $dialogContent.find('.clone-url input').select();
                });
            });
        }, {
            noBind: true,
            width: 360,
            gravity: 'w',
            hideCallback: function() { // hide the dropdown (if it is visible) when the inline dialog is hidden
                var $cloneProtocolTrigger = getCloneUrlProtocolTrigger();
                var $cloneProtocolDropdown = $('#' + $cloneProtocolTrigger.attr("aria-controls"));

                if ($cloneProtocolDropdown.is(':visible')) {
                    $cloneProtocolTrigger.trigger("aui-button-invoke");
                }
            },
            calculatePositions: function () {
                if (dialogPos === null && arrowPos === null) {
                    // launching a standard dialog, fall back to the default implementation
                    return AJS.InlineDialog.opts.calculatePositions.apply(this, arguments);
                } else {
                    return {
                        gravity: 'w',
                        popupCss: dialogPos,
                        arrowCss: arrowPos
                    };
                }
            }
        });
        $(document).on('click' , cloneUrlDialogTrigger, function (e) {
            e.preventDefault();
            var $submenuDialog = $('.aui-sidebar-submenu-dialog');

            // check if the target was outside the sidebar (inside an inline dialog)
            if ($(e.target).closest('.aui-sidebar').length === 0) {
                var $dialog = $submenuDialog.find('.aui-inline-dialog-contents');
                // The absolute position of the dialog for the new dialog
                dialogPos = $dialog.offset();
                // The position of the arrow relative to the dialog for positioning in the new dialog.
                // hard-coded because the submenu is now InlineDialog2 and there's no way to get the position
                // of the arrow because it's a pseudo element
                arrowPos = {top: 6, left: 0};
            } else {
                dialogPos = null;
                arrowPos = null;
            }

            dialog.show(e, this);
            // hide the submenu when the clone dialog is displayed
            $submenuDialog[0].hide();
        });

        $(document).keyup(function(e) {
           if(e.keyCode === AJS.keyCode.ESCAPE) {
               dialog.hide();
           }
        });

        $dialogContent
            .find("a.sourcetree-clone-button")
            .on('click', function () {
                dialog.hide();
          });

        $('#clone-dialog-options').html(bitbucket.internal.layout.cloneDialogOptions());
    }

    function bindCreatePullRequestButton() {
        var $createButton = $(".aui-page-header-actions .create-pull-request");

        events.on('bitbucket.internal.layout.branch.revisionRefChanged', function(revisionReference) {
            var createPullRequestBuilder = nav.currentRepo().createPullRequest();
            if (!revisionReference.isDefault() && revisionReference.isBranch()) {
                createPullRequestBuilder = createPullRequestBuilder.sourceBranch(revisionReference.getId());
            }
            $createButton.attr('href', createPullRequestBuilder.build());
        });
    }

    function bindBadgesTipsy() {
        $('.repository-badge .badge').tooltip({
            gravity: 'n'
        });
    }

    // temporary @aui-override to add tipsy to the project avatar. Should be removed when this is implemented in the
    // AUI sidebar component
    function bindProjectAvatarTipsy() {
        var $trigger = $('.aui-sidebar[aria-expanded=false] .aui-page-header-image');
        $trigger.tooltip({
            gravity: 'w',
            delayIn: 0,
            live: true,
            html: true,
            aria: true,
            className: 'aui-sidebar-section-tooltip',
            title: function() {
                return $(this).find('.aui-avatar').attr('data-tooltip');
            }
       });
    }

    exports.onReady = function(repositoryJson, cloneUrlDialogTrigger, cloneUrlDialogContent) {
        initRepositoryPageState(repositoryJson);
        initCloneUrlInput();
        quickCopyText.onReady();
        $(document).ready(sidebar.onReady);
        stickyBranches.onReady();
        initCloneUrlDialog(cloneUrlDialogTrigger, cloneUrlDialogContent);
        bindCreatePullRequestButton();
        bindBadgesTipsy();
        bindProjectAvatarTipsy();

        events.on('bitbucket.internal.widget.keyboard-shortcuts.register-contexts', function(keyboardShortcuts) {
            keyboardShortcuts.enableContext('repository');
        });
    };
});
