(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/spi/web-fragments'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/web-fragments', ['exports', 'module', 'bitbucket/internal/spi/web-fragments'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var WebFragments = require("bitbucket/internal/spi/web-fragments");

var MockWebFragments = (function (_WebFragments) {
    function MockWebFragments() {
        _classCallCheck(this, MockWebFragments);

        if (_WebFragments != null) {
            _WebFragments.apply(this, arguments);
        }
    }

    _inherits(MockWebFragments, _WebFragments);

    _createClass(MockWebFragments, {
        getWebItems: {
            value: function getWebItems(location, context) {
                return [WebFragments.getExampleItem(location, context)];
            }
        },
        getWebSections: {
            value: function getWebSections(location, context) {
                return [WebFragments.getExampleSection(location, context)];
            }
        },
        getWebPanels: {
            value: function getWebPanels(location, context) {
                return [WebFragments.getExamplePanel(location, context)];
            }
        },
        getWebFragments: {
            value: function getWebFragments(location, types, context) {
                return types.map(function (type) {
                    switch (type) {
                        case "ITEM":
                            return WebFragments.getExampleItem(location, context);
                        case "SECTION":
                            return WebFragments.getExampleSection(location, context);
                        case "PANEL":
                            return WebFragments.getExamplePanel(location, context);
                    }
                });
            }
        }
    });

    return MockWebFragments;
})(WebFragments);

var mock = new MockWebFragments();

module.exports = mock;

});
