import PagedDataProvider from 'bitbucket/internal/paged-data-provider';
import models from 'bitbucket/internal/models';
import validator from 'bitbucket/internal/json-validation';

/**
 * Provides data about users. Implementers should respect the `filter` property, and should
 * transform their data into a {@link UserModel}.
 */
export default class UserDataProvider extends PagedDataProvider {
    constructor(options, ...args) {
        options.jsonDescriptor = [ models.user ];
        options.filterDescriptor = {
            term: 'string?',
            permissions: validator.nullable([ models.permission ])
        };
        super(options, ...args);
    }
}