(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/spi/ref-data-provider', 'bitbucket/internal/mock-models'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/ref-data-provider', ['exports', 'module', 'bitbucket/internal/spi/ref-data-provider', 'bitbucket/internal/mock-models'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var RefDataProvider = require("bitbucket/internal/spi/ref-data-provider");
var mocks = require("bitbucket/internal/mock-models");

var MockRefDataProvider = (function (_RefDataProvider) {
    function MockRefDataProvider() {
        _classCallCheck(this, MockRefDataProvider);

        if (_RefDataProvider != null) {
            _RefDataProvider.apply(this, arguments);
        }
    }

    _inherits(MockRefDataProvider, _RefDataProvider);

    _createClass(MockRefDataProvider, {
        _transform: {
            value: function _transform(d) {
                return d.values.map(function (junk, i) {
                    return mocks.ref(null, "branch-" + i);
                });
            }
        }
    });

    return MockRefDataProvider;
})(RefDataProvider);

module.exports = MockRefDataProvider;

});
