import $ from 'jquery';
import _ from 'lodash';
import AJS from 'aui';
import AvatarList from 'bitbucket/internal/avatar-list';
import PagedTable from 'bitbucket/internal/paged-table';
import Widget from 'bitbucket/internal/widget';

let customMapping = {
    aMomentAgo: function () {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.a.moment.ago');
    },
    oneMinuteAgo: function () {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.minute.ago');
    },
    xMinutesAgo: function (param) {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.minutes.ago', param);
    },
    oneHourAgo: function () {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.hour.ago');
    },
    xHoursAgo: function (param) {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.hours.ago', param);
    },
    oneDayAgo: function () {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.day.ago');
    },
    xDaysAgo: function (param) {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.days.ago', param);
    },
    oneWeekAgo: function () {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.week.ago');
    },
    defaultType: function (param) {
        return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.absolute', param);
    }
};

class PullRequestTable extends PagedTable {
    /**
     * @param {jQuery|HTMLElement} el - the element to render the pull request table in to.
     * @param {Object} options
     * @param {jQuery|HTMLElement} options.tableEl
     * @param {Repository} options.repository
     */
    constructor (el, options = {}) {

        options = $.extend({
                noneFoundMessageHtml: bitbucket.component.pullRequestTable.pullRequestIntro({ repository: options.repository }),
                noneMatchingMessageHtml: bitbucket.component.pullRequestTable.noneMatchingMsg({ repository: options.repository }),
                tableEl: $(bitbucket.component.pullRequestTable.main({ id: 'bitbucket-pull-request-table' }))
            }, options);

        $(el).append(options.tableEl);

        super(options);

        this.$tbody = this.$table.find('tbody');

        AvatarList.init();
    }

    handleNewRows (data) {
        var rowsHtml = data.map(function (pullRequest) {
            return bitbucket.component.pullRequestTable.row({
                customMapping: customMapping,
                pullRequest
            });
        });

        this.$tbody.append(rowsHtml.join(''));
    }

    handleErrors (errors) {
        console.error(errors);
    }

    _moveFocus (...args) {
        super._moveFocus(...args);
        // set browser focus on the PR title link
        this._getFocusedItem().find(this.options.focusOptions.itemLinkSelector).focus();
    }
}

// We do a merge here so that we get all of the paged table defaults for focusOptions as well.
PullRequestTable.defaults = _.merge({}, PagedTable.defaults, {
    autoLoad: true,
    allFetchedMessageHtml: bitbucket.component.pullRequestTable.allFetched()
});

export default PullRequestTable;
