import PullRequestListDataProvider from 'bitbucket/internal/spi/data-provider/pull-request-list';

export default class MockPullRequestListDataProvider extends PullRequestListDataProvider {

    _transform(d) {
        function user(i, type = 'NORMAL') {
            return {
                name: `${type}_USER_${i}`,
                type: type
            };
        }
        function ref(i, dir = 'to') {
            return {
                id : `refs/heads/${dir}_ref_id_${i}`,
                display_id : `${dir}_ref_display_id_${i}`,
                type : 'BRANCH',
                is_default : false,
                latest_commit : 'deadbeef',
                repository: {}
            };
        }

        return d.values.map(function(junk, i) {
            return {
                    author: user(i),
                    description: `PR_Description_${i}`,
                    descriptionAsHtml: `<p>PR_Description_${i}</p>`,
                    created_date: '2015-07-07T14:43:23Z',
                    from_ref: ref(i, 'from'),
                    id: `PR_Id_${i}`,
                    participants: [ user(i, 'PARTICIPANT') ],
                    reviewers: [ user(i, 'REVIEWER') ],
                    state: 'OPEN',
                    title: `PR_Title_${i}`,
                    to_ref: ref(i, 'to'),
                    updated_date: '2015-07-07T14:43:23Z',
                    version: 1
                };
        });
    }

}
