import PagedDataProvider from 'bitbucket/internal/paged-data-provider';
import models from 'bitbucket/internal/models';
import validator from 'bitbucket/internal/json-validation';
import _ from 'lodash';

/**
 * Provides data for a list of pull requests.
 *
 * Implementers should transform data to a {@link models.pullrequest}
 */
export default class PullRequestListDataProvider extends PagedDataProvider {

    constructor (options = {}, ...args) {
        /**
         * We extend the pull_request model with commentCount and taskCount
         */
        options.jsonDescriptor = [_.extend({}, models.pull_request, {
            commentCount: 'number?',
            taskCount: 'number?'
        })];

        /**
         * @type {Object}
         * @property {string?} author_id - the author's username
         * @property {string?} target_ref_id - the ref string, e.g. refs/heads/
         * @property {string?} reviewer_id - the reviewer's username
         * @property {models.PullRequestState?} state
         */
        options.filterDescriptor = {
            author_id: 'string?',
            target_ref_id: 'string?',
            reviewer_id: 'string?',
            state: validator.asEnum('PullRequestState', models.PullRequestState)
        };
        super(options, ...args);
    }


}
