// This file was automatically generated from paged-table.soy.
// Please don't edit this file by hand.

/**
 * @fileoverview Templates in namespace bitbucket.component.pagedTable.
 */

if (typeof bitbucket == 'undefined') { var bitbucket = {}; }
if (typeof bitbucket.component == 'undefined') { bitbucket.component = {}; }
if (typeof bitbucket.component.pagedTable == 'undefined') { bitbucket.component.pagedTable = {}; }


bitbucket.component.pagedTable.table = function(opt_data, opt_ignored) {
  return '' + aui.table({id: opt_data.id, extraClasses: 'paged-table' + ((opt_data.extraClasses) ? ' ' + soy.$$escapeHtml(opt_data.extraClasses) : ''), theadContent: opt_data.theadContent});
};
if (goog.DEBUG) {
  bitbucket.component.pagedTable.table.soyTemplateName = 'bitbucket.component.pagedTable.table';
}


bitbucket.component.pagedTable.message = function(opt_data, opt_ignored) {
  return '<div class="paged-table-message' + ((opt_data.extraClasses) ? ' ' + soy.$$escapeHtml(opt_data.extraClasses) : '') + '">' + soy.$$filterNoAutoescape(opt_data.content) + '</div>';
};
if (goog.DEBUG) {
  bitbucket.component.pagedTable.message.soyTemplateName = 'bitbucket.component.pagedTable.message';
}


bitbucket.component.pagedTable.spinner = function(opt_data, opt_ignored) {
  opt_data = opt_data || {};
  return '<div class=\'spinner ' + soy.$$escapeHtml(opt_data.visible ? '' : 'hidden') + '\'></div>';
};
if (goog.DEBUG) {
  bitbucket.component.pagedTable.spinner.soyTemplateName = 'bitbucket.component.pagedTable.spinner';
}


bitbucket.component.pagedTable.filter = function(opt_data, opt_ignored) {
  return '' + aui.group.group({extraClasses: 'paged-table-filter', content: '' + aui.group.item({content: '' + bitbucket.component.pagedTable.filterField(opt_data)})});
};
if (goog.DEBUG) {
  bitbucket.component.pagedTable.filter.soyTemplateName = 'bitbucket.component.pagedTable.filter';
}


bitbucket.component.pagedTable.filterField = function(opt_data, opt_ignored) {
  return '<label class="assistive" for="paged-table-input-for-' + soy.$$escapeHtml(opt_data.forId) + '">' + soy.$$escapeHtml(opt_data.filterPlaceholder ? opt_data.filterPlaceholder : AJS.I18n.getText('bitbucket.component.pagedTable.search')) + '</label><input type="text" id="paged-table-input-for-' + soy.$$escapeHtml(opt_data.forId) + '" class="paged-table-filter-input" data-for="' + soy.$$escapeHtml(opt_data.forId) + '" autocomplete="off" placeholder="' + soy.$$escapeHtml(opt_data.filterPlaceholder ? opt_data.filterPlaceholder : AJS.I18n.getText('bitbucket.component.pagedTable.search')) + '" value="' + soy.$$escapeHtml(opt_data.filter ? opt_data.filter : '') + '">';
};
if (goog.DEBUG) {
  bitbucket.component.pagedTable.filterField.soyTemplateName = 'bitbucket.component.pagedTable.filterField';
}

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'aui', 'jquery', 'lodash', 'bitbucket/internal/javascript-errors', 'bitbucket/internal/paged-scrollable'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/paged-table', ['exports', 'module', 'aui', 'jquery', 'lodash', 'bitbucket/internal/javascript-errors', 'bitbucket/internal/paged-scrollable'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var AJS = require("aui");
var $ = require("jquery");
var _ = require("lodash");
var javascript_errors = require("bitbucket/internal/javascript-errors");
var PagedScrollable = require("bitbucket/internal/paged-scrollable");

var FocusDirection = {
    NEXT: "next",
    PREVIOUS: "prev"
};

var PagedTable = (function (_PagedScrollable) {
    /**
     * An abstract widget used for tables that wish to handle scroll events and load new rows as the user nears the edge of the page.
     *
     * Support is provided for tables that start with some row content already - the initial count of rows is used as the
     * start of the first page of rows to request.
     *
     * It is assumed sub-classes will want to allow navigation of rows and provision is made for this however it is not
     * strictly necessary for sub-classes to implement.
     *
     * To extend PagedTable, you must implement:
     * this.buildUrl(start, limit) : this must build a URL to retrieve the next page of row data
     * this.handleNewRows(data, attachmentMethod) : given a RestPage object and an attachmentMethod ('prepend', 'append', or 'html'),
     * should add new rows to the table
     * this.handleErrors(errors) : should display something appropriate in response to the errors encountered when retrieving new row data
     *
     * You must also supply the following options for which there are no defaults:
     *  - tableMessageClass - the custom CSS class for the element used to display table messages
     *  - allFetchedMessageHtml - the message shown when all rows have been fetched
     *  - noneFoundMessageHtml - the message shown when there were no rows to display
     *
     * You may wish to supply the following options to override defaults:
     *  - ajaxDataType (defaults to 'json') - the data type of the ajax response
     *  - rowSelector (defaults to '> tbody > tr') - allows other elements (such as lists) to be used instead of an actual HTML table
     *
     *  @param {Object} options
     *  @param {HTMLElement|jQuery} options.tableEl - the target `<table>`
     *  @param {boolean} options.filterable - whether the table is filterable
     *  @param {HTMLElement|jQuery?} options.filterEl - the linked filter, if any. If filterable is set and a filter isn't provided, one will be added to the DOM above the table.
     *  @param {number?} options.filterDebounce - how long to wait before updating the filter
     *  @param {string?} options.scrollPaneSelector
     *  @param {PagedDataProvider} options.dataProvider
     *  @param
     */

    function PagedTable() {
        var _this = this;

        var options = arguments[0] === undefined ? {} : arguments[0];

        _classCallCheck(this, PagedTable);

        _get(Object.getPrototypeOf(PagedTable.prototype), "constructor", this).call(this, options);
        this.$table = $(this.options.tableEl);

        if (this.options.filterable) {
            var tableId = this.$table.attr("id");
            if (!tableId) {
                tableId = _.uniqueId("paged-table-");
                this.$table.attr("id", tableId);
            }

            if (this.options.filterEl) {
                this.$filter = $(this.options.filterEl);
            } else {
                this.$filter = $(bitbucket.component.pagedTable.filter({
                    forId: tableId,
                    filter: this.provider.filter
                }));
                this.$filter.insertBefore(this.$table);
            }

            var onFilterChanged = _.debounce(this._onFilterChanged, this.options.filterDebounce);
            this.$filter.on("keyup.paged-table-filter", function (e) {
                if (e.which === AJS.keyCode.ESCAPE) {
                    $(_this).blur();
                } else {
                    onFilterChanged(e);
                }
            }).on("paste.paged-table-filter", onFilterChanged);
        }

        this.$spinner = $(bitbucket.component.pagedTable.spinner()).insertAfter(this.$table);
        this.provider.on("data-requested", function () {
            _this.$spinner.removeClass("hidden").spin(_this.options.spinnerSize);
        });

        var delayedHideSpinner = _.debounce(function () {
            _this.$spinner.addClass("hidden").spinStop();
        }, 0);

        this.provider.on("data-loaded", delayedHideSpinner);
        this.provider.on("data-request-failed", delayedHideSpinner);
    }

    _inherits(PagedTable, _PagedScrollable);

    return PagedTable;
})(PagedScrollable);

/**
 * @type {Object} defaults
 * @property {string} spinnerSize - the size of the spinner
 * @property {boolean} filterable - should the paged table be filterable?
 * @property {number} bufferPixels - the buffer from the bottom/top of the list at which new content gets loaded
 * @property {number} filterDebounce - time in ms for the filter search debounce callback
 * @property {string} rowSelector - the selector that represents a row in the paged table
 * @property {string} rowKeySelector - the key element selector that represents a row (i.e. the rightmost part of rowSelector)
 * @property {Object} focusOptions
 * @property {string} focusOptions.focusedClass - the CSS class to use on the focused row
 * @property {boolean} focusOptions.wrapAround - should the focus wrap around?
 * @property {string} focusOptions.itemLinkSelector - the selector that represents the link to an item in the row
 */
PagedTable.defaults = {
    spinnerSize: "large",
    filterable: false,
    bufferPixels: 150,
    filterDebounce: 350,
    rowSelector: "> tbody > tr",
    rowKeySelector: "tr",
    focusOptions: {
        focusedClass: "focused",
        wrapAround: false,
        itemLinkSelector: ".title a"
    },
    isFiltered: function isFiltered(pagedTable) {
        var filterText = pagedTable.getFilterText();
        return pagedTable.options.filterable && filterText && filterText.length;
    }
};

PagedTable.prototype.init = function () {
    var _this = this;

    return PagedScrollable.prototype.init.apply(this, arguments).done(function () {
        if (_this.shortcutsInitialised) {
            _this.focusInitialRow();
        }
    });
};

PagedTable.prototype.getFilterText = function () {
    return this.provider.filter.term;
};

PagedTable.prototype._onFilterChanged = function () {
    var term = $.trim(this.$filter.val());
    if (term !== this.provider.filter.term) {
        this.provider.setFilter("term", term);
        this.provider.reset();
    }
};

PagedTable.prototype.reset = function () {
    PagedScrollable.prototype.reset.call(this);
    this.$table.addClass("no-rows");
};

PagedTable.prototype.update = function (options) {
    this.reset();
    return this.init(options);
};

PagedTable.prototype.attachNewContent = function (data) {
    if (data.length) {
        this.handleNewRows(data);
        this._$rows = this.$table.find(this.options.rowSelector);
        if (this.provider.reachedEnd) {
            this.handleLastPage();
        }
        this.$table.removeClass("no-rows");
    } else {
        if (this.provider.reachedEnd) {
            // if the first page has no PRs
            if (this._page === 0) {
                this.handleNoData();
            } else {
                // otherwise must be the last page, so no more pull requests.
                this.handleLastPage();
            }
        }
    }

    // Once we have finished manipulating update the timestamp.
    this.updateTimestamp();
};

/**
 * Modify the last updated timestamp. This should be called after any modification to the
 * table is made. This is useful when writing browser tests
 */
PagedTable.prototype.updateTimestamp = function () {
    this.$table.attr("data-last-updated", new Date().getTime());
};

/**
 * Implement if rows can be focused and keyboard shortcuts allow focus navigation
 */
PagedTable.prototype.focusInitialRow = function () {
    this.$table.find(this.options.rowSelector).first().addClass(this.options.focusOptions.focusedClass);
};

/**
 * Override if keyboard shortcuts are required but be sure to call this method afterwards
 */
PagedTable.prototype.initShortcuts = function () {
    this.shortcutsInitialised = true;
    this.focusInitialRow(); //initShortcuts is called after init, so we need to manually call this the first time.
    return {
        destroy: this.resetShortcuts.bind(this)
    };
};

/**
 *
 * Get the currently focused item in the table.
 * @returns {jQuery}
 * @private
 */
PagedTable.prototype._getFocusedItem = function () {
    return this.$table.find("" + this.options.rowSelector + "." + this.options.focusOptions.focusedClass);
};

/**
 * Open the currently focused item using the focusOptions itemLinkSelector
 */
PagedTable.prototype.openItem = function () {
    var $focusedItem = this._getFocusedItem();
    if ($focusedItem.length) {
        $focusedItem.find(this.options.focusOptions.itemLinkSelector).get(0).click();
    }
};

/**
 * Move the focus to the previous or next row and scroll the focused item in to view if needed
 *
 * @param {FocusDirection} direction - the direction to move
 */
PagedTable.prototype._moveFocus = function (direction) {
    var $focusedItem = this._getFocusedItem();
    var $next = $focusedItem[direction](this.options.rowKeySelector);

    // if we need to wrap around, check if the current item is the first/last item in the list (depending on direction)
    if (this.options.focusOptions.wrapAround) {
        // check if we need to go the first or last item
        if (direction === FocusDirection.NEXT && $focusedItem.is(this._$rows.last())) {
            $next = this._$rows.first();
        }
        if (direction === FocusDirection.PREVIOUS && $focusedItem.is(this._$rows.first())) {
            $next = this._$rows.last();
        }
    }

    if ($focusedItem.length && $next.length) {
        // set focus on the next item and unfocus the previously focused one
        $next.addClass(this.options.focusOptions.focusedClass);
        $focusedItem.removeClass(this.options.focusOptions.focusedClass);

        // Scroll in to view if needed.
        // Check if the $next item is above the upper bound or below the lower bound of
        // the scroll pane's visible area
        var topBound = this.$scrollElement.scrollTop();
        var bottomBound = this.$scrollElement.scrollTop() + this.$scrollElement.height();
        var isOutOfTopBound = $next.offset().top < topBound;
        var isOutOfBottomBound = $next.offset().top + $next.height() > bottomBound;
        if (isOutOfTopBound || isOutOfBottomBound) {
            // align to the bottom when moving up and the top when moving down
            // pass in isOutOfBottomBound as the "alignToTop" boolean because the focused item scrolled in
            // to view should align to the top when the focus has moved passed the bottom of the page
            $next.get(0).scrollIntoView(isOutOfBottomBound);
        }
    }
};

/**
 * Move focus to the next row
 */
PagedTable.prototype.moveNext = function () {
    this._moveFocus(FocusDirection.NEXT);
};

/**
 * Move focus to the previous row
 */
PagedTable.prototype.movePrevious = function () {
    this._moveFocus(FocusDirection.PREVIOUS);
};

PagedTable.prototype.resetShortcuts = function () {
    this.shortcutsInitialised = false;
};

PagedTable.prototype._new$Message = function (content) {
    if (content) {
        return bitbucket.component.pagedTable.message({
            content: content,
            extraClasses: this.options.tableMessageClass
        });
    }
};

PagedTable.prototype.handleLastPage = function () {
    this.$table.after(this._new$Message(this.options.allFetchedMessageHtml));
};

PagedTable.prototype.handleNoData = function () {
    var messageHtml = this.options.isFiltered(this) ? this.options.noneMatchingMessageHtml : this.options.noneFoundMessageHtml;

    this.$table.addClass("no-rows").after(this._new$Message(messageHtml));
};

/**
 * Given an array of Errors, display appropriate error messaging for your implementation.
 * @param {Array<Error>} errors
 * @abstract
 */
PagedTable.prototype.handleErrors = function (errors) {
    throw new errors.NotImplementedError();
};

/**
 *
 * @param {Object} data
 * @abstract
 */
PagedTable.prototype.handleNewRows = function (data) {
    throw new javascript_errors.NotImplementedError();
};

PagedTable.prototype.clear = function () {
    this.$table.children("tbody").empty();
    this.$table.addClass("no-rows").nextAll(".paged-table-message").remove();
};

var index = PagedTable;

module.exports = index;

});
