import PagedDataProvider from 'bitbucket/internal/spi/paged-data-provider';
import $ from 'jquery';


function repeat(n, val) {
    return Array.apply(null, new Array(n)).map(() => val);
}

export default class MockPagedDataProvider extends PagedDataProvider {

    constructor(options, ...args) {
        super(options, ...args);
        this._nextUrl = options.nextUrl;
        this._pages = options.pages == null ? 3 : options.pages | 0;
        this._pagesLeft = this._pages;
        this._itemsPerPage = options.itemsPerPage || 25;
    }

    _reachedEnd (data) {
        return data.isLastPage;
    }

    reset() {
        this._pagesLeft = this._pages;
        super.reset();
    }

    _fetch(url) {
        var pageOfStuff = {
            isLastPage : this._pagesLeft <= 1,
            nextUrl : this._pagesLeft <= 0 ? null : this._nextUrl,
            values: repeat(this._itemsPerPage, url)
        };
        var resolve;
        var reject;
        var p = $.Deferred();
        this._currentDeferred = p;
        p.resolve = (function(oldResolve) {
            return function(val) {
                oldResolve.call(this, val || pageOfStuff);
            };
        }(p.resolve));
        p.abort = p.reject.bind(p, 'abort');
        return p;
    }

    _fetchNext(data) {
        var p = this._fetch(data ? data.nextUrl : this._nextUrl);
        p.then(() => this._pagesLeft--);
        return p;
    }

    _transform(d) {
        return d.values;
    }

    _validate() {

    }

    _errorTransform(d) {
        return d;
    }
}