// This file was automatically generated from index.soy.
// Please don't edit this file by hand.

/**
 * @fileoverview Templates in namespace bitbucket.component.filterBar.
 */

if (typeof bitbucket == 'undefined') { var bitbucket = {}; }
if (typeof bitbucket.component == 'undefined') { bitbucket.component = {}; }
if (typeof bitbucket.component.filterBar == 'undefined') { bitbucket.component.filterBar = {}; }


bitbucket.component.filterBar.main = function(opt_data, opt_ignored) {
  var output = '<div class="filter-bar"' + ((opt_data.id) ? ' id=' + soy.$$escapeHtml(opt_data.id) : '') + '><h6 class="filter-label">' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.component.filter.bar.label')) + '</h6>';
  var filterList11 = opt_data.filters;
  var filterListLen11 = filterList11.length;
  for (var filterIndex11 = 0; filterIndex11 < filterListLen11; filterIndex11++) {
    var filterData11 = filterList11[filterIndex11];
    output += bitbucket.component.filterBar.filter(filterData11);
  }
  output += '</div>';
  return output;
};
if (goog.DEBUG) {
  bitbucket.component.filterBar.main.soyTemplateName = 'bitbucket.component.filterBar.main';
}


bitbucket.component.filterBar.filter = function(opt_data, opt_ignored) {
  var output = '';
  if (opt_data.type == 'TOGGLE') {
    output += aui.buttons.button({type: 'subtle', text: opt_data.text, id: opt_data.id, isPressed: opt_data.value});
  } else if (opt_data.type == 'SELECT' && opt_data.menu.items) {
    output += '<label for="' + soy.$$escapeHtml(opt_data.id) + '" class="assistive">' + soy.$$escapeHtml(opt_data.text) + '</label><select id="' + soy.$$escapeHtml(opt_data.id) + '">';
    var itemList31 = opt_data.menu.items;
    var itemListLen31 = itemList31.length;
    for (var itemIndex31 = 0; itemIndex31 < itemListLen31; itemIndex31++) {
      var itemData31 = itemList31[itemIndex31];
      output += '<option value="' + soy.$$escapeHtml(itemData31.id) + '"' + ((itemData31.disabled) ? ' disabled' : '') + ((opt_data.value == itemData31.id) ? ' selected' : '') + '>' + soy.$$escapeHtml(itemData31.text) + '</option>';
    }
    output += '</select>';
  } else {
    output += '<label for="' + soy.$$escapeHtml(opt_data.id) + '" class="assistive">' + soy.$$escapeHtml(opt_data.text) + '</label><input id="' + soy.$$escapeHtml(opt_data.id) + '" type="hidden" value="' + soy.$$escapeHtml(opt_data.value ? opt_data.value : '') + '" />';
  }
  return output;
};
if (goog.DEBUG) {
  bitbucket.component.filterBar.filter.soyTemplateName = 'bitbucket.component.filterBar.filter';
}


bitbucket.component.filterBar.loadMore = function(opt_data, opt_ignored) {
  return '<div class="spinner"></div>';
};
if (goog.DEBUG) {
  bitbucket.component.filterBar.loadMore.soyTemplateName = 'bitbucket.component.filterBar.loadMore';
}

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/widget', 'aui', 'jquery', 'lodash', 'internal/util/navigator'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/filter-bar', ['exports', 'module', 'bitbucket/internal/widget', 'aui', 'jquery', 'lodash', 'internal/util/navigator'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var Widget = require("bitbucket/internal/widget");
var AJS = require("aui");
var $ = require("jquery");
var _ = require("lodash");
var navigatorUtil = require("internal/util/navigator");

var FilterType = {
    SELECT: "SELECT", // a dropdown menu - loaded synchronously or via AJAX
    TOGGLE: "TOGGLE" // a toggle button - on or off
};

/**
 * @class FilterDescriptor
 * @property {FilterType} type - the type of this filter
 * @property {string} id - the HTML ID for the filter, as well as the key under which the filter's state will be returned. Must be unique on the page.
 * @property {string} text -
 */
function validateFilters(filters) {
    var filtersById = {};
    filters.forEach(function (filter) {
        ["type", "id", "text"].forEach(function (prop) {
            if (typeof filter[prop] !== "string") {
                throw new Error("Every filter needs a " + prop);
            }
        });
        if (filter.type === "SELECT") {
            var menu = filter.menu;
            if (!menu) {
                throw new Error("select filters need a menu configuration.");
            }
            if (!menu.items) {
                if (!menu.dataProvider || !menu.placeholder) {
                    if (!menu.dataProvider && !menu.placeholder) {
                        throw new Error("select filters need a menu with either hardcoded items or dataProvider and placeholder.");
                    }
                    throw new Error("When items aren't provided, dataProvider and placeholder must be.");
                }
            } else if (menu.dataProvider) {
                throw new Error("items is mutually exclusive with dataProvider.");
            }
        }
        if (filtersById[filter.id]) {
            throw new Error("duplicated ID " + filter.id);
        }
        filtersById[filter.id] = filter;
    });
}

function initToggle(filter, $filter) {
    $filter.click(function () {
        $filter.attr("aria-pressed", $filter.attr("aria-pressed") && $filter.attr("aria-pressed") !== "false" ? null : "true");
        $filter.trigger("change");
    });
}

function initStaticSelect(filter, $filter) {
    var defaults = {
        minimumResultsForSearch: -1 // don't show the search box.
    };
    var overrides = {};
    $filter.auiSelect2(_.extend(defaults, filter.menu, overrides));
}

function initAsyncSelect(filter, $filter) {
    var menu = filter.menu;
    var dataProvider = menu.dataProvider;
    var $searchBoxSpinner = $(bitbucket.component.filterBar.loadMore());
    dataProvider.__test = 0;
    var defaults = {
        minimumInputLength: 0,
        dropdownAutoWidth: true,
        formatSearching: function formatSearching() {
            return AJS.I18n.getText("bitbucket.component.filter.bar.searching");
        },
        formatNoMatches: function formatNoMatches() {
            return AJS.I18n.getText("bitbucket.component.filter.bar.nomatches");
        }
    };
    var overrides = {
        allowClear: true,
        containerCssClass: ("filter-bar-async " + (menu.containerCssClass || "")).trim(),
        dropdownCssClass: ("filter-bar-async filter-bar-dropdown-" + filter.id + " " + (menu.dropdownCssClass || "")).trim(),
        query: (function (_query) {
            var _queryWrapper = function query(_x) {
                return _query.apply(this, arguments);
            };

            _queryWrapper.toString = function () {
                return _query.toString();
            };

            return _queryWrapper;
        })(function (query) {
            dataProvider.setFilter("term", query.term);

            if (query.page <= 1) {
                // first page for this search.
                $searchBoxSpinner.spin();
                dataProvider.reset();
            }

            var _ref = dataProvider.fetchNext ? {
                more: function () {
                    return !dataProvider.reachedEnd;
                },
                promise: dataProvider.fetchNext()
            } : {
                more: function () {
                    return false;
                },
                promise: dataProvider.fetch()
            };

            var more = _ref.more;
            var promise = _ref.promise;

            var $spinner = $(".select2-more-results").html(bitbucket.component.filterBar.loadMore());
            $spinner.spin();

            promise.then(function (items) {
                $spinner.spinStop();
                $searchBoxSpinner.spinStop();
                query.callback({
                    context: query.context,
                    results: menu.transform ? items.map(menu.transform) : items,
                    more: more()
                });
            });
        }),
        formatLoadMore: function formatLoadMore() {
            return " "; // blank out the default text because we're replacing it with the spinner
        },
        ajax: undefined
    };
    $filter.auiSelect2(_.extend(defaults, menu, overrides));
    $filter.on("select2-opening", function (e) {
        if ($filter.select2("val")) {
            // if there's a selection, force the clearing of it instead of opening.
            e.preventDefault();
            $filter.select2("val", "", true); // clear and trigger change
        }
    });
    if (filter.searchPlaceholder && !navigatorUtil.isIE()) {
        // IE11 & below will fail - see STASHDEV-10518
        $filter.one("select2-open", function () {
            // make sure it's filtered by specific dropdown so this only affects the select2 that $filter belongs to
            $(".filter-bar-dropdown-" + filter.id + " .select2-search > input").attr("placeholder", filter.searchPlaceholder).after($searchBoxSpinner);
        });
    }
}

var FilterBar = (function (_Widget) {
    /**
     * @param {jQuery|HTMLElement} el
     * @param {Object} options
     */

    function FilterBar(el, options) {
        var _this = this;

        _classCallCheck(this, FilterBar);

        _get(Object.getPrototypeOf(FilterBar.prototype), "constructor", this).call(this, options);
        validateFilters(options.filters);

        var $filterBar = this._$filterBar = $(bitbucket.component.filterBar.main({
            id: options.id,
            filters: options.filters.map(function (filter) {
                if (!filter.menu || !filter.menu.item || !filter.menu.transform) {
                    return filter;
                }
                filter = _.deepClone(filter);
                filter.menu.items = filter.menu.items.map(filter.menu.transform);
                return filter;
            })
        }));

        options.filters.forEach(function (filter) {
            var $filter = $filterBar.find("#" + filter.id);
            switch (filter.type) {
                case FilterType.TOGGLE:
                    initToggle(filter, $filter);
                    break;
                case FilterType.SELECT:
                    if (filter.menu.items) {
                        // static
                        initStaticSelect(filter, $filter);
                    } else {
                        // data provider
                        initAsyncSelect(filter, $filter);
                    }
                    break;
            }
        });

        $(el).append($filterBar);
        $filterBar.on("change", function () {
            _this.trigger("change");
        });
    }

    _inherits(FilterBar, _Widget);

    _createClass(FilterBar, {
        state: {
            get: function () {
                var _this = this;

                return _.transform(this.options.filters, function (state, filter) {
                    var $filter = _this._$filterBar.find("#" + filter.id);
                    state[filter.id] = filter.type === FilterType.TOGGLE ? !!$filter.attr("aria-pressed") && $filter.attr("aria-pressed") !== "false" : $filter.val();
                }, {});
            },
            set: function (filters) {
                var _this = this;

                _.map(filters, function (state, filter) {
                    var $filter = _this._$filterBar.find("#" + filter);
                    if ($filter.is("button")) {
                        $filter.attr("aria-pressed", state);
                    } else {
                        $filter.select2("val", state);
                    }
                });
                this.trigger("change");
            }
        }
    }, {
        Types: {
            get: function () {
                return FilterType;
            }
        }
    });

    return FilterBar;
})(Widget);

var index = FilterBar;

module.exports = index;

});
