# bitbucket-filter-bar

> A configurable set of toggle buttons or dropdowns that apply a filter to a list or table.

## Installation

```
> bower install --save bitbucket-filter-bar
```

## Usage

Initialize the FilterBar with a description of the filters in it. Then listen to the "change" method and read the `state` to get a map of ID to value for each filter.

```
var filterBar = new FilterBar(containerEl, options);

filterBar.on('change', function() {
    console.log(filterBar.state);
});

```

### Options

```
{
    id : 'an HTML ID to give the bar itself'
    filters: [{ // a list of filters to place in the bar.
        id: 'an HTML ID for the filter, and also the key that will be used when outputting the filter's state,
        text: 'A label to display for the filter. This is the text of a toggle button, or merely assistive for select filters.',
        type: 'toggle|select',
        value: 'the  ID of the item to initially select for the filter'
    }, {
        id: 'filter-two',
        text: 'filter two',
        type: 'select',
        menu: { // A select filter requires a menu to describe results
            items : [{ // you can either hardcode items (which will be passed to Select2), or pass a dataProvider and placeholder (see below)
                id : 'item-one',
                text: 'item one'
            }, {
                id : 'item-two',
                text: 'item two'
            }],
            formatResults: function() {
                console.log('You can also pass any Select2 options through here. Note that if you provide a dataProvider, then you can't pass through query or AJAX');
            }
        }
    }, {
        id: 'filter-three',
        text: 'filter three',
        type: 'select',
        menu: {
            dataProvider: new DummyDataProvider(),
            transform: function(rawItem) { return transformed(rawItem) }, // do whatever transforms you want on the dataProvider output.
            placeholder: 'Text that will show in the filter when nothing is selected.'
        },
        value: initialValues && initialValues['filter-three']
    }]
}
```


## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt test
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 1.2.1

- increased padding around search input
- increased height of search input
- removed inset gradient on search input
- removed magnifying glass icon that appears only on retina screens
- removed the select2 default text and animated gif spinner and show an AUI spinner instead when loading more results
- i18n for 'loading' and 'no results' text
- styles for 'loading' and 'no results' text to look more like Bitbucket Server
- removed dropdown max-width (moved to pull-request-list component)

### 1.2.0

- Fixed hover states and selected states CSS
- Added CSS for a clear button
- Added support for a search placeholder (Select2 doesn't have this out of the box)
- Made it clear when clicked, instead of opening the dropdown

### 0.1.0

Initial release
