# bitbucket-time

> Time utility for rendering date and timestamps

## Installation

```
> bower install --save bitbucket-time
```

## Usage

The `bitbucket-time` component uses moment.js under the hood and provides methods for rendering dates in several common
formats in both absolute and relative times (e.g. 'x minutes ago').

The simplest use of this component is require('bitbucket/internal/time').format(dateOrNumberOrString, typeString) which
returns a formatted string of the specified type. Valid types are 'shortAge', 'longAge', 'short', 'long', 'full' and 
'timestamp'.

The formatDateWithFormatString() and formatDateWithRelativeAge() methods are also exposed if you need more control 
over the formatted time.

The `dateFormats` object is copied from Bitbucket Server and should be kept in sync with the Java implementation.

The relative time strings can be extended by consumers of this component, but defining their own custom mappings of the
relative age types to their own i18n keys. See [bitbucket-pull-request-table](https://stash.atlassian.com/projects/BB/repos/bitbucket-pull-request-table/browse/src/index.js) 
for an example of a component that does this.


## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt test
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 1.1.2
- fixes incorrect use of Stash-specific i18n for unknown dates. Added new key in this component for that
- prefixed all i18n keys with `bitbucket-component` for consistency with other BUI components

### 1.1.1
- Fixes moment.js deprecation warnings

### 1.1.0

- Updated the versions of bitbucket-soy-functions, bitbucket-global-styles and jquery dependencies

### 1.0.0
- Adds the ability a consumer to define their own i18n key mappings to the built-in relative age strings. 

### 0.1.1

Initial release
