import PagedDataProvider from 'bitbucket/internal/paged-data-provider';
import models from 'bitbucket/internal/models';
import validator from 'bitbucket/internal/json-validation';

export default class RefDataProvider extends PagedDataProvider {
    constructor(options, ...args) {
        options.jsonDescriptor = [ models.ref ];
        options.filterDescriptor = {
            term: 'string?',
            repository: models.repository,
            type: validator.asEnum('RefType', models.RefType)
        };
        super(options, ...args);
    }
}