# bitbucket-ref-data-provider

An SPI for paged ref data.

## Installation

```
> bower install --save bitbucket-ref-data-provider
```

## Usage

Implement a RefDataProvider like:

```js
import RefDataProviderSPI from 'bitbucket/internal/spi/ref-data-provider';

export default class RefDataProvider extends RefDataProviderSPI {

    _fetch(url) { // Likely to be implemented in a super class instead of here.
        return $.getJSON(url);
    }

    _reachedEnd(lastResponseData) { // Likely to be implemented in a super class instead of here.
        return !lastResponseData.next;
    }

    _fetchNext(lastResponseData) {
        var url = lastResponseData.next ||
            ('http://example.com/rest/refs' + this.filter.repository_id);
        return this._fetch(url);
    }

    _transform(responseData) {
        return responseData.values.map(makeRef);
    }
}
```

Use one like:

```js
import RefDataProvider from 'bitbucket/internal/ref-data-provider';

var provider = new RefDataProvider({
    filter: {
        repository_id: '7'  // create a provider filtered to a certain repo.
    }
});

function getEverythingFoolishly(allRefs) {
    if (provider.reachedEnd) { // stop when there's no more
        return Promise.resolve(allRefs);
    }

    return provider.fetchNext().then(function(refs) { // otherwise get some more
        return getEverythingFoolishly(allRefs.concat(refs));
    });
}

getEverythingFoolishly([]);
```

## Developing

This is a Bitbucket UI (BUI) Shared Component. It follows the same development patterns as other BUI components.

For example, to run linting and compile output as you develop, you can run:

```
> grunt
```

To run linting checks:

```
> grunt lint
```

To run tests:

```
> grunt build test # or grunt test --force if you know what you're doing and running grunt to watch and build separately
```

For more information, see [Development on a Bitbucket UI Shared Component](https://extranet.atlassian.com/x/gCiUkw)

Please also follow [these guidelines](https://extranet.atlassian.com/display/BB/Bitbucket+UI+Shared+Component+API+Guidelines) during your development.

## Releasing a new version

1. Ensure your changes are unit tested!!
1. Update `bower.json` to a new version number (use [Semantic Versioning](http://semver.org/) to choose the correct next version)
1. Ensure the /dist has been populated by running `grunt release`.
1. `git commit` your changes.
1. `git tag {version}` to label this commit as a given version of the component.
1. `git push && git push --tags` to push both your commit and your tag to the central repository.

## Changes

### 0.1.0

Initial release
