(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/spi/data-provider/pull-request-list'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/data-provider/pull-request-list', ['exports', 'module', 'bitbucket/internal/spi/data-provider/pull-request-list'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var PullRequestListDataProvider = require("bitbucket/internal/spi/data-provider/pull-request-list");

var MockPullRequestListDataProvider = (function (_PullRequestListDataProvider) {
    function MockPullRequestListDataProvider() {
        _classCallCheck(this, MockPullRequestListDataProvider);

        if (_PullRequestListDataProvider != null) {
            _PullRequestListDataProvider.apply(this, arguments);
        }
    }

    _inherits(MockPullRequestListDataProvider, _PullRequestListDataProvider);

    _createClass(MockPullRequestListDataProvider, {
        _transform: {
            value: function _transform(d) {
                function user(i) {
                    var type = arguments[1] === undefined ? "NORMAL" : arguments[1];

                    return {
                        name: "" + type + "_USER_" + i,
                        type: type
                    };
                }
                function ref(i) {
                    var dir = arguments[1] === undefined ? "to" : arguments[1];

                    return {
                        id: "refs/heads/" + dir + "_ref_id_" + i,
                        display_id: "" + dir + "_ref_display_id_" + i,
                        type: "BRANCH",
                        is_default: false,
                        latest_commit: "deadbeef",
                        repository: {}
                    };
                }

                return d.values.map(function (junk, i) {
                    return {
                        author: user(i),
                        description: "PR_Description_" + i,
                        descriptionAsHtml: "<p>PR_Description_" + i + "</p>",
                        created_date: "2015-07-07T14:43:23Z",
                        from_ref: ref(i, "from"),
                        id: "PR_Id_" + i,
                        participants: [user(i, "PARTICIPANT")],
                        reviewers: [user(i, "REVIEWER")],
                        state: "OPEN",
                        title: "PR_Title_" + i,
                        to_ref: ref(i, "to"),
                        updated_date: "2015-07-07T14:43:23Z",
                        version: 1
                    };
                });
            }
        }
    });

    return MockPullRequestListDataProvider;
})(PullRequestListDataProvider);

module.exports = MockPullRequestListDataProvider;

});
