// This file was automatically generated from index.soy.
// Please don't edit this file by hand.

/**
 * @fileoverview Templates in namespace bitbucket.component.pullRequestTable.
 */

if (typeof bitbucket == 'undefined') { var bitbucket = {}; }
if (typeof bitbucket.component == 'undefined') { bitbucket.component = {}; }
if (typeof bitbucket.component.pullRequestTable == 'undefined') { bitbucket.component.pullRequestTable = {}; }


bitbucket.component.pullRequestTable.main = function(opt_data, opt_ignored) {
  opt_data = opt_data || {};
  var output = '<table class="aui paged-table pull-requests-table"' + ((opt_data.id) ? ' id=' + soy.$$escapeHtml(opt_data.id) : '') + '><thead><tr><th class="title" scope="col">Summary</th>';
  var webSectionList9 = require('bitbucket/internal/web-fragments').getWebSections('bitbucket.pull-request.table-column.before');
  var webSectionListLen9 = webSectionList9.length;
  for (var webSectionIndex9 = 0; webSectionIndex9 < webSectionListLen9; webSectionIndex9++) {
    var webSectionData9 = webSectionList9[webSectionIndex9];
    output += '<th class="' + soy.$$escapeHtml(webSectionData9.key) + '" title="' + soy.$$escapeHtml(webSectionData9.text) + '" scope="col">' + soy.$$escapeHtml(webSectionData9.text) + '</th>';
  }
  output += '<th class="reviewers" scope="col">Reviewers</th>';
  var webSectionList19 = require('bitbucket/internal/web-fragments').getWebSections('bitbucket.pull-request.table-column.after');
  var webSectionListLen19 = webSectionList19.length;
  for (var webSectionIndex19 = 0; webSectionIndex19 < webSectionListLen19; webSectionIndex19++) {
    var webSectionData19 = webSectionList19[webSectionIndex19];
    output += '<th class="' + soy.$$escapeHtml(webSectionData19.key) + '" title="' + soy.$$escapeHtml(webSectionData19.text) + '" scope="col">' + soy.$$escapeHtml(webSectionData19.text) + '</th>';
  }
  output += '</tr></thead><tbody></tbody></table>';
  return output;
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.main.soyTemplateName = 'bitbucket.component.pullRequestTable.main';
}


bitbucket.component.pullRequestTable.row = function(opt_data, opt_ignored) {
  var output = '<tr class="pull-request-row" data-pull-request-id="' + soy.$$escapeHtml(opt_data.pullRequest.id) + '"><td class="title"><div class="title-and-target-branch"><a class="pull-request-title" title="' + soy.$$escapeHtml(opt_data.pullRequest.title) + '" href="' + soy.$$escapeHtml(require('bitbucket/internal/urls')['pullRequest'](opt_data.pullRequest)) + '">' + soy.$$escapeHtml(opt_data.pullRequest.title) + '</a>' + aui.icons.icon({useIconFont: true, iconFontSet: 'devtools', icon: 'arrow-right'}) + '<span class="pull-request-target-branch">' + bitbucket.component.refLabel.main({ref: opt_data.pullRequest.to_ref}) + '</span></div><div class="author-and-timestamp">' + bitbucket.component.avatars.avatarWithName({person: opt_data.pullRequest.author, size: 'xsmall'}) + ', ' + bitbucket.component.pullRequestTable.updatedAge({date: opt_data.pullRequest.updated_date, customMapping: opt_data.customMapping}) + '</div></td>';
  var webSectionList55 = require('bitbucket/internal/web-fragments').getWebSections('bitbucket.pull-request.table-column.before');
  var webSectionListLen55 = webSectionList55.length;
  for (var webSectionIndex55 = 0; webSectionIndex55 < webSectionListLen55; webSectionIndex55++) {
    var webSectionData55 = webSectionList55[webSectionIndex55];
    output += bitbucket.component.pullRequestTable.pullRequestRowExtras({webSection: webSectionData55, pullRequest: opt_data.pullRequest, position: 'before'});
  }
  output += '<td class="reviewers">' + bitbucket.component.avatarList.participantList({participants: opt_data.pullRequest.reviewers, menuId: 'reviewers-' + opt_data.pullRequest.id, menuClass: 'pull-request-table-reviewers', maxOpen: 3, avatarSize: 'small'}) + '</td>';
  var webSectionList69 = require('bitbucket/internal/web-fragments').getWebSections('bitbucket.pull-request.table-column.after');
  var webSectionListLen69 = webSectionList69.length;
  for (var webSectionIndex69 = 0; webSectionIndex69 < webSectionListLen69; webSectionIndex69++) {
    var webSectionData69 = webSectionList69[webSectionIndex69];
    output += bitbucket.component.pullRequestTable.pullRequestRowExtras({webSection: webSectionData69, pullRequest: opt_data.pullRequest, position: 'after'});
  }
  output += '</tr>';
  return output;
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.row.soyTemplateName = 'bitbucket.component.pullRequestTable.row';
}


bitbucket.component.pullRequestTable.updatedAge = function(opt_data, opt_ignored) {
  return '<time title="' + soy.$$escapeHtml(opt_data.title ? opt_data.title : require('bitbucket/internal/time').format(opt_data.date, 'full')) + '" datetime="' + soy.$$escapeHtml(require('bitbucket/internal/time').format(opt_data.date, 'timestamp')) + '"' + ((opt_data.extraClasses) ? ' class="' + soy.$$escapeHtml(opt_data.extraClasses) + '"' : '') + '>' + soy.$$escapeHtml(require('bitbucket/internal/time').format(opt_data.date, 'shortAge', opt_data.customMapping)) + '</time>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.updatedAge.soyTemplateName = 'bitbucket.component.pullRequestTable.updatedAge';
}


bitbucket.component.pullRequestTable.pullRequestIntro = function(opt_data, opt_ignored) {
  return '<div class="pull-request-intro"><h1 class="intro-title">' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.pull.request.intro.title')) + '</h1><div class="intro-columns">' + bitbucket.component.pullRequestTable.introColumn({name: AJS.I18n.getText('bitbucket.pull.request.intro.branch.name'), imageClass: 'intro-branch', descriptionContent: '' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.pull.request.intro.branch.description'))}) + bitbucket.component.pullRequestTable.introColumn({name: AJS.I18n.getText('bitbucket.pull.request.intro.discuss.name'), imageClass: 'intro-discuss', descriptionContent: '' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.pull.request.intro.discuss.description'))}) + bitbucket.component.pullRequestTable.introColumn({name: AJS.I18n.getText('bitbucket.pull.request.intro.merge.name'), imageClass: 'intro-merge', descriptionContent: AJS.I18n.getText('bitbucket.pull.request.intro.merge.description', '<a href="' + require('bitbucket/internal/urls')['help']('help.pull.request') + '" target="_blank">', '</a>')}) + '</div></div>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.pullRequestIntro.soyTemplateName = 'bitbucket.component.pullRequestTable.pullRequestIntro';
}


bitbucket.component.pullRequestTable.introColumn = function(opt_data, opt_ignored) {
  return '<div class="intro-column"><div class="intro-image ' + soy.$$escapeHtml(opt_data.imageClass) + '"></div><h2>' + soy.$$escapeHtml(opt_data.name) + '</h2><p>' + soy.$$filterNoAutoescape(opt_data.descriptionContent) + '</p></div>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.introColumn.soyTemplateName = 'bitbucket.component.pullRequestTable.introColumn';
}


bitbucket.component.pullRequestTable.noneMatchingMsg = function(opt_data, opt_ignored) {
  return '<div class="empty-banner-content"><h3>' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.pull.request.no.matches')) + '</h3><p>' + soy.$$filterNoAutoescape(AJS.I18n.getText('bitbucket.pull.request.no.matches.description', '<a href="' + require('bitbucket/internal/urls')['allPullRequests'](opt_data.repository) + '">', '</a>')) + '</p></div>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.noneMatchingMsg.soyTemplateName = 'bitbucket.component.pullRequestTable.noneMatchingMsg';
}


bitbucket.component.pullRequestTable.allFetched = function(opt_data, opt_ignored) {
  return '<p class="no-more-results">' + soy.$$escapeHtml(AJS.I18n.getText('bitbucket.pull.request.all.fetched')) + '</p>';
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.allFetched.soyTemplateName = 'bitbucket.component.pullRequestTable.allFetched';
}


bitbucket.component.pullRequestTable.pullRequestRowExtras = function(opt_data, opt_ignored) {
  var output = '';
  var webPanelList130 = require('bitbucket/internal/web-fragments').getWebPanels('bitbucket.pull-request.table-column.' + opt_data.position + '/' + opt_data.webSection.key,{pullRequest: opt_data.pullRequest}).map(function(webPanel) {    webPanel.html = soydata.VERY_UNSAFE.ordainSanitizedHtml(webPanel.html);    return webPanel;});
  var webPanelListLen130 = webPanelList130.length;
  for (var webPanelIndex130 = 0; webPanelIndex130 < webPanelListLen130; webPanelIndex130++) {
    var webPanelData130 = webPanelList130[webPanelIndex130];
    output += '<td class="' + soy.$$escapeHtml(opt_data.webSection.key) + '-value">' + soy.$$escapeHtml(webPanelData130.html) + '</td>';
  }
  return output;
};
if (goog.DEBUG) {
  bitbucket.component.pullRequestTable.pullRequestRowExtras.soyTemplateName = 'bitbucket.component.pullRequestTable.pullRequestRowExtras';
}

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'jquery', 'lodash', 'aui', 'bitbucket/internal/avatar-list', 'bitbucket/internal/paged-table', 'bitbucket/internal/widget'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/pull-request-table', ['exports', 'module', 'jquery', 'lodash', 'aui', 'bitbucket/internal/avatar-list', 'bitbucket/internal/paged-table', 'bitbucket/internal/widget'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var $ = require("jquery");
var _ = require("lodash");
var AJS = require("aui");
var AvatarList = require("bitbucket/internal/avatar-list");
var PagedTable = require("bitbucket/internal/paged-table");
var Widget = require("bitbucket/internal/widget");

var index__customMapping = {
    aMomentAgo: function aMomentAgo() {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.a.moment.ago");
    },
    oneMinuteAgo: function oneMinuteAgo() {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.one.minute.ago");
    },
    xMinutesAgo: function xMinutesAgo(param) {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.x.minutes.ago", param);
    },
    oneHourAgo: function oneHourAgo() {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.one.hour.ago");
    },
    xHoursAgo: function xHoursAgo(param) {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.x.hours.ago", param);
    },
    oneDayAgo: function oneDayAgo() {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.one.day.ago");
    },
    xDaysAgo: function xDaysAgo(param) {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.x.days.ago", param);
    },
    oneWeekAgo: function oneWeekAgo() {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.one.week.ago");
    },
    defaultType: function defaultType(param) {
        return AJS.I18n.getText("bitbucket.pull.request.updated.date.format.absolute", param);
    }
};

var PullRequestTable = (function (_PagedTable) {
    /**
     * @param {jQuery|HTMLElement} el - the element to render the pull request table in to.
     * @param {Object} options
     * @param {jQuery|HTMLElement} options.tableEl
     * @param {Repository} options.repository
     */

    function PullRequestTable(el) {
        var options = arguments[1] === undefined ? {} : arguments[1];

        _classCallCheck(this, PullRequestTable);

        options = $.extend({
            noneFoundMessageHtml: bitbucket.component.pullRequestTable.pullRequestIntro({ repository: options.repository }),
            noneMatchingMessageHtml: bitbucket.component.pullRequestTable.noneMatchingMsg({ repository: options.repository }),
            tableEl: $(bitbucket.component.pullRequestTable.main({ id: "bitbucket-pull-request-table" }))
        }, options);

        $(el).append(options.tableEl);

        _get(Object.getPrototypeOf(PullRequestTable.prototype), "constructor", this).call(this, options);

        this.$tbody = this.$table.find("tbody");

        AvatarList.init();
    }

    _inherits(PullRequestTable, _PagedTable);

    _createClass(PullRequestTable, {
        handleNewRows: {
            value: function handleNewRows(data) {
                var rowsHtml = data.map(function (pullRequest) {
                    return bitbucket.component.pullRequestTable.row({
                        customMapping: index__customMapping,
                        pullRequest: pullRequest
                    });
                });

                this.$tbody.append(rowsHtml.join(""));
            }
        },
        handleErrors: {
            value: function handleErrors(errors) {
                console.error(errors);
            }
        },
        _moveFocus: {
            value: function _moveFocus() {
                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                _get(Object.getPrototypeOf(PullRequestTable.prototype), "_moveFocus", this).apply(this, args);
                // set browser focus on the PR title link
                this._getFocusedItem().find(this.options.focusOptions.itemLinkSelector).focus();
            }
        }
    });

    return PullRequestTable;
})(PagedTable);

// We do a merge here so that we get all of the paged table defaults for focusOptions as well.
PullRequestTable.defaults = _.merge({}, PagedTable.defaults, {
    autoLoad: true,
    allFetchedMessageHtml: bitbucket.component.pullRequestTable.allFetched()
});

var index = PullRequestTable;

module.exports = index;

});
