(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/spi/paged-data-provider', 'jquery'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/paged-data-provider', ['exports', 'module', 'bitbucket/internal/spi/paged-data-provider', 'jquery'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(object, property, receiver) { var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc && desc.writable) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var PagedDataProvider = require("bitbucket/internal/spi/paged-data-provider");
var $ = require("jquery");

function repeat(n, val) {
    return Array.apply(null, new Array(n)).map(function () {
        return val;
    });
}

var MockPagedDataProvider = (function (_PagedDataProvider) {
    function MockPagedDataProvider(options) {
        var _get2;

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
        }

        _classCallCheck(this, MockPagedDataProvider);

        (_get2 = _get(Object.getPrototypeOf(MockPagedDataProvider.prototype), "constructor", this)).call.apply(_get2, [this, options].concat(args));
        this._nextUrl = options.nextUrl;
        this._pages = options.pages == null ? 3 : options.pages | 0;
        this._pagesLeft = this._pages;
        this._itemsPerPage = options.itemsPerPage || 25;
    }

    _inherits(MockPagedDataProvider, _PagedDataProvider);

    _createClass(MockPagedDataProvider, {
        _reachedEnd: {
            value: function _reachedEnd(data) {
                return data.isLastPage;
            }
        },
        reset: {
            value: function reset() {
                this._pagesLeft = this._pages;
                _get(Object.getPrototypeOf(MockPagedDataProvider.prototype), "reset", this).call(this);
            }
        },
        _fetch: {
            value: function _fetch(url) {
                var pageOfStuff = {
                    isLastPage: this._pagesLeft <= 1,
                    nextUrl: this._pagesLeft <= 0 ? null : this._nextUrl,
                    values: repeat(this._itemsPerPage, url)
                };
                var resolve;
                var reject;
                var p = $.Deferred();
                this._currentDeferred = p;
                p.resolve = (function (oldResolve) {
                    return function (val) {
                        oldResolve.call(this, val || pageOfStuff);
                    };
                })(p.resolve);
                p.abort = p.reject.bind(p, "abort");
                return p;
            }
        },
        _fetchNext: {
            value: function _fetchNext(data) {
                var _this = this;

                var p = this._fetch(data ? data.nextUrl : this._nextUrl);
                p.then(function () {
                    return _this._pagesLeft--;
                });
                return p;
            }
        },
        _transform: {
            value: function _transform(d) {
                return d.values;
            }
        },
        _validate: {
            value: function _validate() {}
        },
        _errorTransform: {
            value: function _errorTransform(d) {
                return d;
            }
        }
    });

    return MockPagedDataProvider;
})(PagedDataProvider);

module.exports = MockPagedDataProvider;

});
