(function (factory) {
    if (typeof define === 'function' && define.amd) {
        define(['exports', 'module', 'bitbucket/internal/models', 'lodash'], factory);
    } else if (typeof define === 'function' && !define.amd) {
        define('bitbucket/internal/mock-models', ['exports', 'module', 'bitbucket/internal/models', 'lodash'], factory);
    } else if (typeof exports !== 'undefined') {
        factory(exports, module);
    }
})(function (exports, module) {

"use strict";

var models = require("bitbucket/internal/models");
var _ = require("lodash");

function strToNumber(str) {
    [].reduce.call(str, function (sum, c, i) {
        return sum + c.charCodeAt(0) * i % 17;
    }, 0);
}

function user(overrides, str) {
    str += "";
    return _.extend({
        name: "USER" + str,
        display_name: "User " + str,
        email_address: "user" + str + "@example.com",
        is_active: true,
        is_admin: false,
        type: models.UserType.NORMAL,
        avatar_url: "http://example.com/user-" + str + "-avatar.png"
    }, overrides);
}

function pullRequest(overrides, str) {
    str += "";
    return _.extend({
        id: Number(str) || strToNumber(str),
        to_ref: ref(null, str + "_to"),
        from_ref: ref(null, str + "_from")
    }, overrides);
}

function ref(overrides, str) {
    str += "";
    return _.extend({
        id: "refs/heads/" + str,
        display_id: str,
        type: models.RefType.BRANCH,
        is_default: false,
        latest_commit: "c0ffee",
        repository: repository(null, str + "_repo")
    }, overrides);
}

function repository(overrides, str) {
    str += "";
    return _.extend({
        id: str,
        name: "Repo " + str,
        slug: "repo-" + str.replace(/[^a-zA-Z0-9]+/g, "-"),
        is_forkable: true,
        is_public: false,
        origin: null,
        scm_id: models.scmId.GIT
    }, overrides);
}

function project(overrides, str) {
    return _.extend({
        id: str,
        key: "PROJ" + str.replace(/[^a-zA-Z0-9]+/g, "").toUpperCase(),
        name: "Project " + str,
        type: models.ProjectType.NORMAL,
        owner: null,
        is_public: false
    }, overrides);
}

var mock = {
    user: user,
    pullRequest: pullRequest,
    ref: ref,
    repository: repository,
    project: project
};

module.exports = mock;

});
