import _ from 'lodash';
import $ from 'jquery';


export default {
    updateApproval(listEl, participant) {
        var $avatars = $(listEl).find(".user-avatar[data-username='" + participant.getUser().getName() + "']");
        $avatars.toggleClass("badge-hidden", !participant.getApproved());
    },

    init: _.once(function() {
        $(".avatar-tooltip > .aui-avatar-inner > img").tooltip({
            hoverable: false,
            offset: 5,
            gravity: function() {
                // Always position on screen
                return $.fn.tipsy.autoNS.call(this) + $.fn.tipsy.autoWE.call(this);
            },
            delayIn: 0,
            live: true
        });
    })

};