define('bitbucket/internal/page/pull-request/pull-request-view', [
    'aui',
    'aui/flag',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/layout/pull-request',
    'exports'
], function (
    AJS,
    auiFlag,
    pageState,
    pullRequestLayout,
    exports
) {

    exports.registerHandler = pullRequestLayout.registerHandler;

    exports.onReady = function(unwatched) {
        if (unwatched) {
            auiFlag({
                type: 'success',
                title: AJS.I18n.getText('stash.web.pullrequest.unwatched.header',
                    pageState.getPullRequest().getId()),
                close: 'auto',
                body: AJS.I18n.getText('stash.web.pullrequest.unwatched.content')
            });
        }
    };
});
