define('bitbucket/internal/page/maintenance/migration', [
    'aui',
    'bitbucket/internal/layout/maintenance',
    'bitbucket/util/navbuilder',
    'exports'
], function(
    AJS,
    maintenance,
    nav,
    exports
) {
        exports.onReady = function(hasToken) {

            var opts = {
                redirectUrl: hasToken ? nav.admin().db().build() : nav.allProjects().build(),
                canceledHeader: AJS.I18n.getText('stash.web.migration.canceled.title'),
                cancelingDescription: AJS.I18n.getText('stash.web.migration.canceling.description'),
                cancelDialogTitle: AJS.I18n.getText('stash.web.migration.dialog.title'),
                cancelDialogDescription: AJS.I18n.getText('stash.web.migration.dialog.description', bitbucket.internal.util.productName()),
                cancelDialogButtonText: AJS.I18n.getText('stash.web.migration.dialog.cancel')
            };

            maintenance.init(opts);
        };
});
