define('bitbucket/internal/page/admin/groupsList', [
    'aui',
    'bitbucket/internal/util/notifications',
    'bitbucket/internal/widget/delete-dialog',
    'bitbucket/internal/feature/user/group-table',
    'exports'
], function(
    AJS,
    notifications,
    deleteDialog,
    GroupTable,
    exports) {

    exports.onReady = function(tableSelector, deleteLinksSelector) {

        notifications.showFlashes();

        var groupTable = new GroupTable({
            target : tableSelector
        });

        groupTable.init();

        // confirm dialog to delete groups
        deleteDialog.bind(deleteLinksSelector,
            AJS.I18n.getText('stash.web.group.delete'),
            AJS.I18n.getText('stash.web.group.delete.success'),
            AJS.I18n.getText('stash.web.group.delete.fail'),
            function(group) {
                notifications.addFlash(AJS.I18n.getText('stash.web.group.delete.success', group));
                location.reload();
            });
    };
});
