define('bitbucket/internal/feature/file-content/stash-codemirror/stash-scrollbar', [
    'codemirror',
    'jquery'
], function(
    CodeMirror,
    $
) {

    // This file is based on the NativeScrollbars implementation from CodeMirror 4.12.0
    // All vertical scrollbar specific code has been removed.

    // The main fix in this file is a fix for the horizontal scrollbar not working over gutters in CodeMirror 4.12.0

    function StashScrollbars(place, scroll, cm) {
        this.cm = cm;
        var $innerEl = $('<div>').css('height', '100%').css('min-height', '1px');
        var horiz = this.horiz = $('<div>').addClass('CodeMirror-hscrollbar').css('min-height', '18px').append($innerEl)[0];
        place(horiz);

        CodeMirror.on(horiz, "scroll", function() {
            if (horiz.clientWidth) {
                scroll(horiz.scrollLeft, "horizontal");
            }
        });
    }

    StashScrollbars.prototype = {
        update: function(measure) {
            var needsH = measure.scrollWidth > measure.clientWidth + 1;
            var sWidth = measure.nativeBarWidth;

            if (needsH) {
                this.horiz.style.display = "block";
                this.horiz.style.right = "0";
                this.horiz.style.left = measure.barLeft + "px";
                this.horiz.firstChild.style.width =
                    (measure.scrollWidth - measure.clientWidth + (measure.barWidth || this.horiz.clientWidth)) + "px";
            } else {
                this.horiz.style.display = "";
                this.horiz.firstChild.style.width = "0";
            }
            return {right: 0, bottom: needsH ? sWidth : 0};
        },
        setScrollLeft: function(pos) {
            if (this.horiz.scrollLeft !== pos) {
                this.horiz.scrollLeft = pos;
            }
        },
        setScrollTop: function(pos) {
        },
        clear: function() {
            var parent = this.horiz.parentNode;
            parent.removeChild(this.horiz);
            parent.removeChild(this.vert);
        }
    };

    CodeMirror.scrollbarModel.stash = StashScrollbars;
});
