/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RepositoryStateCondition
implements Condition {
    @VisibleForTesting
    static final String PARAM_STATE = "state";
    @VisibleForTesting
    static final String REPOSITORY = "repository";
    private Repository.State repositoryState;

    public void init(Map<String, String> params) throws PluginParseException {
        Objects.requireNonNull(params, "params");
        try {
            this.repositoryState = Repository.State.valueOf((String)params.get(PARAM_STATE).toUpperCase(Locale.ROOT).replace("-", "_"));
        }
        catch (NullPointerException e) {
            throw new PluginParseException(String.format("%s: The parameter '%s' is required for this condition", this.getClass().getSimpleName(), PARAM_STATE));
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(String.format("%s: Value of the parameter '%s' is invalid", this.getClass().getSimpleName(), PARAM_STATE));
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Object repository = context.get(REPOSITORY);
        return !(repository instanceof Repository) || this.repositoryState == ((Repository)repository).getState();
    }
}

