/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class IsForgedLicenseCondition
implements Condition {
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;

    public IsForgedLicenseCondition(LicenseService licenseService, ApplicationPropertiesService propertiesService) {
        this.licenseService = licenseService;
        this.propertiesService = propertiesService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            return false;
        }
        return this.licenseService.isLicenseForged() && !this.licenseService.isTestingLicense();
    }
}

