/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.SimpleFeature;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class IsFeatureEnabledCondition
implements Condition {
    static final String DATA_CENTER = "dataCenter";
    static final String DEFAULT_VALUE = "defaultValue";
    static final String KEY = "key";
    private final FeatureManager featureManager;
    private boolean defaultValue;
    private Feature feature;

    public IsFeatureEnabledCondition(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    protected IsFeatureEnabledCondition(FeatureManager featureManager, Feature feature) {
        this.featureManager = featureManager;
        this.feature = Objects.requireNonNull(feature, "feature");
    }

    @Deprecated
    protected IsFeatureEnabledCondition(FeatureManager featureManager, StandardFeature feature) {
        this(featureManager, (Feature)feature);
    }

    public void init(Map<String, String> params) throws PluginParseException {
        if (this.feature == null) {
            String featureKeyAsString = params.get(KEY);
            if (StringUtils.isBlank((CharSequence)featureKeyAsString)) {
                throw new PluginParseException(this.getClass().getSimpleName() + " requires the parameter " + KEY);
            }
            try {
                this.feature = StandardFeature.fromKey((String)featureKeyAsString);
            }
            catch (IllegalArgumentException e) {
                this.feature = new SimpleFeature.Builder(featureKeyAsString).dataCenter(Boolean.parseBoolean(params.get(DATA_CENTER))).build();
            }
        }
        this.defaultValue = Boolean.parseBoolean(params.get(DEFAULT_VALUE));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.featureManager.isEnabled(this.feature, this.defaultValue);
    }
}

