/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;

public class HasApprovedPullRequestCondition
implements Condition {
    private static final String PULL_REQUEST = "pullRequest";
    private final AuthenticationContext authenticationContext;

    public HasApprovedPullRequestCondition(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        PullRequest pullRequest = (PullRequest)context.get(PULL_REQUEST);
        LinkedHashSet allParticipants = Sets.newLinkedHashSet();
        allParticipants.add(pullRequest.getAuthor());
        allParticipants.addAll(pullRequest.getReviewers());
        allParticipants.addAll(pullRequest.getParticipants());
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            String currentUsername = currentUser.getName();
            for (PullRequestParticipant participant : allParticipants) {
                if (!currentUsername.equals(participant.getUser().getName())) continue;
                return participant.isApproved();
            }
        }
        return false;
    }
}

