/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class HasDatabaseOfTypeCondition
implements Condition {
    static final String TYPE = "type".intern();
    private final ApplicationPropertiesService applicationPropertiesService;
    private Collection<String> types = Lists.newArrayList();

    public HasDatabaseOfTypeCondition(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String types = params.get(TYPE);
        if (types == null) {
            throw new PluginParseException("A database 'type' must be specified");
        }
        this.types = Arrays.stream(types.split(",")).map(input -> "jdbc:" + input.toLowerCase()).collect(Collectors.toList());
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String jdbcUrl = this.applicationPropertiesService.getJdbcUrl().toLowerCase();
        return this.types.stream().anyMatch(jdbcUrl::startsWith);
    }
}

