/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util.web;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class PeekableHttpServletRequest
extends HttpServletRequestWrapper {
    private final int bufferSize;
    private String content;
    private BufferedServletInputStream inputStream;

    public PeekableHttpServletRequest(HttpServletRequest request, int bufferSize) {
        super(request);
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() throws IOException {
        if (this.content == null) {
            Object inputStream = this.getInputStream();
            inputStream.mark(this.getBufferSize());
            try {
                if ("gzip".equals(this.getHeader("content-encoding"))) {
                    inputStream = new GZIPInputStream((InputStream)inputStream);
                }
                this.content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                this.getInputStream().reset();
            }
        }
        return this.content;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BufferedServletInputStream(super.getInputStream(), this.bufferSize);
        }
        return this.inputStream;
    }

    private static class BufferedServletInputStream
    extends ServletInputStream {
        private final int bufferSize;
        private final BufferedInputStream bufferedStream;
        private final ServletInputStream inputStream;
        private int curPos = -1;
        private int markPos = -1;
        private int maxPos = -1;

        private BufferedServletInputStream(ServletInputStream inputStream, int bufferSize) {
            this.bufferSize = bufferSize;
            this.inputStream = inputStream;
            this.bufferedStream = new BufferedInputStream((InputStream)inputStream, bufferSize);
        }

        public int available() throws IOException {
            return this.bufferedStream.available();
        }

        public void close() throws IOException {
            this.bufferedStream.close();
        }

        public boolean isFinished() {
            return this.inputStream.isFinished() && this.availableOrZero() == 0;
        }

        public boolean isReady() {
            return this.inputStream.isReady() || this.availableOrZero() > 0;
        }

        public void mark(int readlimit) {
            this.bufferedStream.mark(readlimit);
            this.markPos = this.curPos;
            this.maxPos = this.curPos + readlimit;
        }

        public boolean markSupported() {
            return this.bufferedStream.markSupported();
        }

        public int read() throws IOException {
            this.ensureBufferNotAtLimit();
            int result = this.bufferedStream.read();
            if (result != -1) {
                ++this.curPos;
            }
            return result;
        }

        public int read(@Nonnull byte[] bytes, int off, int len) throws IOException {
            int result;
            this.ensureBufferNotAtLimit();
            if (this.maxPos != -1) {
                int bytesAvailable = this.maxPos - this.curPos;
                len = Math.min(len, bytesAvailable);
            }
            if ((result = this.bufferedStream.read(bytes, off, len)) > 0) {
                this.curPos += result;
            }
            return result;
        }

        public void reset() throws IOException {
            this.bufferedStream.reset();
            this.curPos = this.markPos;
            this.maxPos = -1;
        }

        public void setReadListener(ReadListener readListener) {
            this.inputStream.setReadListener(readListener);
        }

        public long skip(long n) throws IOException {
            int limit = this.maxPos != -1 ? this.maxPos : this.bufferSize - 1;
            long maxSkippable = Math.max(0, limit - this.curPos);
            if (n > maxSkippable) {
                return maxSkippable;
            }
            return super.skip(n);
        }

        private int availableOrZero() {
            try {
                return this.available();
            }
            catch (IOException e) {
                return 0;
            }
        }

        private void ensureBufferNotAtLimit() throws IOException {
            if (this.maxPos >= 0 && this.curPos >= this.maxPos) {
                throw new IOException("Buffer is already at the limit; reading more would prevent resetting the InputStream");
            }
        }
    }
}

