/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public class TextUtils {
    private TextUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String pluralise(String word, long n) {
        return TextUtils.pluralise(word, word + "s", n);
    }

    public static String pluralise(String singular, String plural, long n) {
        Preconditions.checkArgument((n >= 0L ? 1 : 0) != 0);
        return n > 1L ? plural : singular;
    }

    public static String truncatePath(String path, int startSegments, int endSegments, int len) {
        Preconditions.checkArgument((len > 0 ? 1 : 0) != 0, (Object)"len must be positive");
        Preconditions.checkArgument((startSegments >= 0 ? 1 : 0) != 0, (Object)"startSegments must be zero or more");
        Preconditions.checkArgument((endSegments >= 0 ? 1 : 0) != 0, (Object)"endSegments must be zero or more");
        int pathLength = path.length();
        if (pathLength <= len) {
            return path;
        }
        List<String> segments = Arrays.asList(path.split("/", 0));
        if (startSegments + endSegments >= segments.size()) {
            return path;
        }
        boolean trailingSlash = path.endsWith("/");
        int endIndex = segments.size() - endSegments;
        for (int index = startSegments; index < endIndex; ++index) {
            if (index == startSegments) {
                oldValue = segments.set(index, "...");
                pathLength -= oldValue.length() - 3;
            } else {
                oldValue = segments.set(index, null);
                pathLength -= oldValue.length() + 1;
            }
            if (pathLength <= len) break;
        }
        StringBuilder pathBuilder = new StringBuilder(pathLength);
        pathBuilder = Joiner.on((char)'/').skipNulls().appendTo(pathBuilder, segments);
        if (trailingSlash) {
            pathBuilder.append('/');
        }
        if (pathBuilder.length() > path.length()) {
            return path;
        }
        return pathBuilder.toString();
    }
}

