/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.cache.Supplier;
import com.google.common.collect.ForwardingMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestLocalMap<K, V> {
    private final RequestLocal<ConcurrentMap<K, V>> cache;

    public RequestLocalMap(RequestManager requestManager) {
        this.cache = requestManager.newRequestLocal();
    }

    public V get(@Nonnull K key, @Nonnull Supplier<V> loader) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(loader, "loader");
        if (this.cache.isActive()) {
            return (V)((ConcurrentMap)this.cache.computeIfAbsent(ConcurrentHashMap::new)).computeIfAbsent(key, ignored -> loader.get());
        }
        return (V)loader.get();
    }

    @Nullable
    public Map<K, V> asMap() {
        if (this.cache.isActive()) {
            return new ForwardingMap<K, V>(){

                protected Map<K, V> delegate() {
                    if (!RequestLocalMap.this.cache.isActive()) {
                        throw new IllegalStateException("Not in a request scope!");
                    }
                    return (Map)RequestLocalMap.this.cache.computeIfAbsent(ConcurrentHashMap::new);
                }
            };
        }
        return null;
    }
}

