/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.SetFilePermissionRequest;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static File construct(@Nonnull File base, String ... segments) {
        return segments.length == 0 ? base : new File(base, FileUtils.join(segments));
    }

    public static boolean isFileWithin(@Nonnull File testPath, @Nonnull File expectedParent) throws IOException {
        Objects.requireNonNull(testPath, "testPath");
        Objects.requireNonNull(expectedParent, "expectedParent");
        Preconditions.checkArgument((boolean)expectedParent.isDirectory(), (Object)"expectedParent is not a directory");
        File canonicalParentDirectory = expectedParent.getCanonicalFile();
        File canonicalFile = testPath.getCanonicalFile();
        return canonicalFile.toPath().startsWith(canonicalParentDirectory.toPath());
    }

    @Nonnull
    public static String join(String ... segments) {
        return StringUtils.join((Object[])segments, (String)File.separator);
    }

    public static void mkdir(@Nonnull File directory) {
        Objects.requireNonNull(directory, "directory");
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException(directory.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!directory.mkdirs()) {
            throw new IllegalStateException("Could not create " + directory.getAbsolutePath());
        }
    }

    @Nonnull
    public static File mkdir(@Nonnull String path) {
        Preconditions.checkArgument((!Objects.requireNonNull(path, "path").trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(path);
        FileUtils.mkdir(dir);
        return dir;
    }

    @Nonnull
    public static File mkdir(@Nullable File parent, @Nonnull String child) {
        Preconditions.checkArgument((!Objects.requireNonNull(child, "child").trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(parent, child);
        FileUtils.mkdir(dir);
        return dir;
    }

    public static void setFilePermission(@Nonnull SetFilePermissionRequest request) throws IOException {
        MoreFiles.setPermissions((SetFilePermissionRequest)request);
    }

    public static void requireFileWithin(@Nonnull File testPath, @Nonnull File expectedParent) throws IOException {
        if (!FileUtils.isFileWithin(testPath, expectedParent)) {
            throw new IllegalArgumentException(testPath + " is not contained within " + expectedParent);
        }
    }
}

