/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.FilteredPageImpl;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageImpl;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PageUtils {
    protected PageUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static <S, ST extends S, P extends Page<S>, SP extends Page<ST>> P asPageOf(@Nonnull Class<S> supertype, @Nullable SP page) {
        Objects.requireNonNull(supertype, "supertype");
        return (P)page;
    }

    public static <T> Page<T> createEmptyPage(PageRequest pageRequest) {
        return PageUtils.createPage(Collections.emptyList(), pageRequest);
    }

    public static <T> Page<T> createPage(Iterable<T> elements, PageRequest request) {
        int size = Iterables.size(elements);
        boolean lastPage = size <= request.getLimit();
        int pageSize = lastPage ? size : request.getLimit();
        return new PageImpl(request, pageSize, Iterables.limit(elements, (int)pageSize), lastPage);
    }

    public static <T> Page<T> createPage(Iterable<T> elements, boolean lastPage, PageRequest request) {
        int size = Iterables.size(elements);
        int pageSize = lastPage ? size : request.getLimit();
        return new PageImpl(request, pageSize, Iterables.limit(elements, (int)pageSize), lastPage);
    }

    public static <T> Page<T> createPage(PageRequest request, Function<Integer, T> elementGenerator) {
        int index;
        T element;
        ArrayList<T> values = new ArrayList<T>();
        int num = request.getLimit() + 1;
        for (int i = 0; i < num && (element = elementGenerator.apply(index = request.getStart() + i)) != null; ++i) {
            values.add(element);
        }
        return PageUtils.createPage(values, request);
    }

    @Nonnull
    public static <T> Page<T> filterPages(@Nonnull PageProvider<T> provider, @Nonnull Predicate<? super T> predicate, @Nonnull PageRequest request) {
        Page<T> internalPage;
        int internalStart = request.getStart();
        int internalLimit = Math.min(request.getLimit() * 2, 0x100000);
        int pageLimit = request.getLimit() + 1;
        TreeMap results = new TreeMap();
        PageRequest internalRequest = PageUtils.newRequest(internalStart, internalLimit);
        block0: do {
            internalPage = provider.get(internalRequest);
            for (Map.Entry entry : internalPage.getOrdinalIndexedValues().entrySet()) {
                if (!predicate.test(entry.getValue())) continue;
                results.put((Integer)entry.getKey(), entry.getValue());
                if (results.size() < pageLimit) continue;
                break block0;
            }
        } while ((internalRequest = internalPage.getNextPageRequest()) != null);
        int size = results.size();
        boolean lastPage = size < pageLimit;
        int pageSize = lastPage ? size : request.getLimit();
        return new FilteredPageImpl(request, pageSize, results, lastPage);
    }

    @Nonnull
    public static PageRequest newRequest(int start, int limit) {
        return new PageRequestImpl(start, limit);
    }

    @Nonnull
    public static <T> Page<T> reducePage(Page<T> page, int limit, PageRequest request) {
        Preconditions.checkArgument((request.getLimit() >= limit ? 1 : 0) != 0);
        return new PageImpl(request.buildRestrictedPageRequest(limit), Iterables.limit((Iterable)page.getValues(), (int)limit), page.getSize() <= limit);
    }

    @Nonnull
    public static <T> Iterable<T> toIterable(@Nonnull PageProvider<T> pageProvider, int batchSize) {
        return new PagedIterable<T>(Objects.requireNonNull(pageProvider, "pageProvider"), batchSize);
    }

    @Nonnull
    public static <T> Stream<T> toStream(@Nonnull PageProvider<T> pageProvider, int batchSize) {
        return MoreStreams.streamIterable(PageUtils.toIterable(pageProvider, batchSize));
    }
}

