/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.http.url.SameOrigin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Pattern REDUNDANT_SLASHES = Pattern.compile("//+");
    private static final Map<String, Integer> DEFAULT_PORTS = ImmutableMap.builder().put((Object)"http", (Object)80).put((Object)"https", (Object)443).build();
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String encodeURL(String fragment) {
        try {
            return URLEncoder.encode(fragment, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static String encodeURL(@Nonnull Object fragment) {
        Objects.requireNonNull(fragment, "fragment");
        if (UrlUtils.shouldEncode(fragment)) {
            return UrlUtils.encodeURL(String.valueOf(fragment));
        }
        return String.valueOf(fragment);
    }

    public static String decodeURL(String fragment) {
        try {
            return URLDecoder.decode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static Object dontEncode(@Nullable Object object) {
        if (object == null || object instanceof DontEncode) {
            return object;
        }
        return new DontEncode(object);
    }

    public static URI uncheckedCreateURI(@Nullable String uri) {
        if (uri != null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(uri + " is not a valid URI.");
            }
        }
        return null;
    }

    public static String concatenate(String base, String ... paths) {
        return StringUtils.stripEnd((String)base, (String)"/") + UrlUtils.removeRedundantSlashes("/" + StringUtils.join((Object[])paths, (String)"/"));
    }

    public static URI concatenate(URI base, String ... paths) throws URISyntaxException {
        return new URI(UrlUtils.concatenate(base.toASCIIString(), paths));
    }

    public static URI uncheckedConcatenate(URI base, URI ... paths) {
        try {
            String[] pathStrings = (String[])Iterables.toArray((Iterable)Lists.transform((List)Lists.newArrayList((Object[])paths), from -> from.toASCIIString()), String.class);
            return UrlUtils.concatenate(base, pathStrings);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to concatenate URIs", e);
        }
    }

    public static URI uncheckedConcatenateAndToUri(String base, String ... paths) {
        return UrlUtils.uncheckedCreateURI(UrlUtils.concatenate(base, paths));
    }

    public static URI uncheckedConcatenate(URI base, String ... paths) {
        try {
            return UrlUtils.concatenate(base, paths);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Failed to concatenate %s to form URI (%s)", base, e.getReason()), e);
        }
    }

    public static String removeRedundantSlashes(String path) {
        return path == null ? null : REDUNDANT_SLASHES.matcher(path).replaceAll("/");
    }

    public static URI copyOf(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri.toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to copy URI: " + uri.toASCIIString());
        }
    }

    public static URI trimTrailingSlashesFromPath(URI uri) {
        try {
            String urlPath = uri.getPath();
            if (urlPath.endsWith("/")) {
                while (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), urlPath, uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Trimming slashes from path of " + uri + " resulted in invalid URI", e);
        }
    }

    public static String replaceBaseUrlWithConfigured(NavBuilder navBuilder, String absoluteUrl) {
        String requestBaseUrl = navBuilder.buildAbsolute();
        String configuredBaseUrl = navBuilder.buildConfigured();
        return configuredBaseUrl + absoluteUrl.substring(requestBaseUrl.length());
    }

    @Nullable
    public static String interpolateUserInfo(@Nullable String url, @Nullable String username) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        if (username == null) {
            return url;
        }
        URI uri = new URI(url);
        return new URI(uri.getScheme(), username, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
    }

    @Nullable
    public static String tryInterpolateUserInfo(@Nullable String url, @Nullable String username) {
        try {
            return UrlUtils.interpolateUserInfo(url, username);
        }
        catch (URISyntaxException e) {
            log.warn("Could not set user in remote URL {}", (Object)url, (Object)e);
            return url;
        }
    }

    @Nonnull
    public static String buildQueryParams(Object ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; i += 2) {
            Object paramName = params[i];
            Object paramValue = params[i + 1];
            if (paramName == null || paramValue == null) continue;
            if (sb.length() != 0) {
                sb.append('&');
            }
            sb.append(paramName).append('=').append(UrlUtils.encodeURL(paramValue));
        }
        return sb.toString();
    }

    @Nonnull
    public static String buildQueryParamsFromMap(Map<?, ? extends Iterable<?>> params) {
        StringBuilder sb = new StringBuilder();
        boolean separatorNeeded = false;
        for (Map.Entry<?, Iterable<?>> entry : params.entrySet()) {
            Object paramName = entry.getKey();
            if (paramName == null) continue;
            Iterable<?> paramList = entry.getValue();
            if (Iterables.isEmpty(paramList)) {
                sb.append(separatorNeeded ? "&" : "").append(paramName);
                separatorNeeded = true;
            }
            for (Object paramValue : paramList) {
                if (paramValue == null) continue;
                sb.append(separatorNeeded ? "&" : "").append(paramName).append('=').append(UrlUtils.encodeURL(paramValue));
                separatorNeeded = true;
            }
        }
        return sb.toString();
    }

    public static Map<String, List<Object>> splitQuery(String queryParams) {
        return MoreStreams.streamIterable((Iterable)Splitter.on((char)'&').split((CharSequence)StringUtils.defaultString((String)queryParams))).filter(StringUtils::isNotBlank).map(s -> s.split("=")).filter(pair -> StringUtils.isNotBlank((CharSequence)pair[0])).collect(Collectors.toMap(pair -> pair[0], pair -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (((String[])pair).length > 1) {
                builder.add((Object)pair[1]);
            }
            return builder.build();
        }, (v1, v2) -> ImmutableList.builder().addAll((Iterable)v1).addAll((Iterable)v2).build()));
    }

    public static String setQueryParams(String queryParams, Map<String, List<Object>> additionalParams) {
        HashMap<String, List<Object>> newParams = new HashMap<String, List<Object>>(additionalParams);
        newParams.putAll(UrlUtils.splitQuery(queryParams));
        return UrlUtils.buildQueryParamsFromMap(newParams);
    }

    public static String safeUrlForRedirect(String url, String baseUrl, String fallbackUrl) {
        if (url != null) {
            try {
                URI uri = new URI(url);
                if (UrlUtils.isLocalPath(uri)) {
                    return url.charAt(0) == '/' ? url : '/' + url;
                }
                URI redirectUri = UrlUtils.getCanonicalUri(uri);
                if (SameOrigin.isSameOrigin((URI)redirectUri, (URI)new URI(baseUrl)) && redirectUri.toString().startsWith(baseUrl)) {
                    return url;
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return fallbackUrl;
    }

    public static String getCanonicalUrl(String url) {
        URI uri = URI.create(url);
        return UrlUtils.getCanonicalUri(uri).toString();
    }

    public static URI getCanonicalUri(URI uri) {
        StringBuilder builder = new StringBuilder().append(StringUtils.lowerCase((String)uri.getScheme())).append("://").append(uri.getHost());
        if (UrlUtils.hasCustomPort(uri)) {
            builder.append(":").append(uri.getPort());
        }
        builder.append(uri.getPath());
        return URI.create(builder.toString());
    }

    public static String getPathAndQuery(String uri) {
        String path = "/";
        try {
            URI url = new URI(uri);
            String p = url.getPath();
            String q = url.getQuery();
            if (p.length() > 0) {
                path = p;
            }
            if (!path.startsWith("/") && path.contains("/")) {
                path = path.substring(path.indexOf(47));
            }
            if (p.length() > 0 && q != null && q.length() > 0) {
                path = path + "?" + q;
            }
            if (!(url.isAbsolute() || p.length() != 0 || q != null && q.length() != 0)) {
                path = uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return path;
    }

    private static boolean shouldEncode(Object object) {
        return !(object instanceof DontEncode);
    }

    @VisibleForTesting
    protected static boolean isLocalPath(URI uri) {
        return StringUtils.isNotEmpty((CharSequence)uri.getPath()) && uri.getAuthority() == null && uri.getHost() == null && uri.getPort() == -1 && uri.getScheme() == null;
    }

    private static boolean hasCustomPort(URI uri) {
        if (uri.getPort() < 0) {
            return false;
        }
        Integer defaultPort = DEFAULT_PORTS.get(StringUtils.lowerCase((String)uri.getScheme(), (Locale)Locale.ROOT));
        return defaultPort == null || defaultPort.intValue() != uri.getPort();
    }

    private static class DontEncode {
        private final Object delegate;

        private DontEncode(@Nonnull Object delegate) {
            Objects.requireNonNull(delegate);
            this.delegate = delegate;
        }

        public String toString() {
            return String.valueOf(this.delegate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DontEncode that = (DontEncode)o;
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

