/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UrlHrefUtils {
    private static final Set<String> ALLOWED_SCHEMES = ImmutableSet.builder().add((Object)"http").add((Object)"https").add((Object)"ftp").add((Object)"ftps").add((Object)"mailto").build();
    private static final URI FALLBACK_URL = URI.create("#");

    private UrlHrefUtils() {
        throw new UnsupportedOperationException("UrlHrefUtils is a constants class and cannot be instantiated");
    }

    @Nullable
    public static String getSanitizedUrl(@Nullable String uri) {
        if (StringUtils.isBlank((CharSequence)uri) || UrlHrefUtils.isSchemeAllowed(uri)) {
            return uri;
        }
        return FALLBACK_URL.toASCIIString();
    }

    @Nullable
    public static URI getSanitizedUrl(@Nullable URI uri) {
        if (uri == null || UrlHrefUtils.isSchemeAllowed(uri)) {
            return uri;
        }
        return FALLBACK_URL;
    }

    public static boolean isSchemeAllowed(@Nonnull String uri) {
        try {
            return UrlHrefUtils.isSchemeAllowed(new URI(Objects.requireNonNull(uri)));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isSchemeAllowed(@Nonnull URI uri) {
        String scheme = Objects.requireNonNull(uri).getScheme();
        if (StringUtils.isBlank((CharSequence)scheme)) {
            return true;
        }
        return ALLOWED_SCHEMES.contains(scheme.toLowerCase(Locale.US));
    }
}

