/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.UrlUtils;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ContentDispositionUtils {
    private static final String FILENAME_HEADER = "; filename=";
    private static final String UTF8_FILENAME_HEADER = "; filename*=UTF-8''";

    private ContentDispositionUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String buildHeaderValue(@Nonnull DispositionType dispositionType, @Nonnull String filename) {
        Objects.requireNonNull(dispositionType, "dispositionType");
        Objects.requireNonNull(filename, "filename");
        return dispositionType.name().toLowerCase(Locale.ROOT) + FILENAME_HEADER + "\"" + ContentDispositionUtils.replaceNonAscii(filename) + "\"" + UTF8_FILENAME_HEADER + UrlUtils.encodeURL(filename);
    }

    private static String replaceNonAscii(String str) {
        return str.replaceAll("[^\\p{ASCII}]", "_");
    }

    public static enum DispositionType {
        ATTACHMENT,
        INLINE;


        public static DispositionType fromString(String str) {
            return DispositionType.valueOf(str.toUpperCase(Locale.ROOT));
        }
    }
}

