/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.project.ProjectMovedException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RedirectUtils {
    private RedirectUtils() {
        throw new UnsupportedOperationException("RedirectUtils is a utilities class and should not be instantiated");
    }

    @Nonnull
    public static Optional<String> getRedirectUrl(@Nonnull HttpServletRequest request, @Nonnull EntityMovedException e) {
        if (e instanceof RepositoryMovedException) {
            return RedirectUtils.getRedirectUrl(request, RedirectUtils.getRepositoryUrlMappings((RepositoryMovedException)e));
        }
        if (e instanceof ProjectMovedException) {
            return RedirectUtils.getRedirectUrl(request, RedirectUtils.getProjectUrlMappings((ProjectMovedException)e));
        }
        return Optional.empty();
    }

    private static List<Pair<String, String>> getProjectUrlMappings(ProjectMovedException e) {
        return ImmutableList.of((Object)Pair.of((Object)e.getOldKey(), (Object)e.getProject().getKey()));
    }

    @Nonnull
    private static Optional<String> getRedirectUrl(HttpServletRequest request, List<Pair<String, String>> mappings) {
        String uri = RedirectUtils.getRequestUri(request);
        String queryString = request.getQueryString();
        Optional<String> mappedUri = RedirectUtils.maybeReplace(uri, mappings);
        Optional<String> mappedQs = RedirectUtils.maybeReplace(queryString, mappings);
        if (mappedUri.isPresent() || mappedQs.isPresent()) {
            String uriResult = mappedUri.orElse(uri);
            String qsResult = mappedQs.orElse(queryString);
            return Optional.of(uriResult + (StringUtils.isNotBlank((CharSequence)qsResult) ? "?" + qsResult : ""));
        }
        return Optional.empty();
    }

    private static List<Pair<String, String>> getRepositoryUrlMappings(RepositoryMovedException e) {
        String oldKey = e.getOldProjectKey();
        String oldSlug = e.getOldSlug();
        Repository repository = e.getRepository();
        String newKey = repository.getProject().getKey();
        String newSlug = repository.getSlug();
        return ImmutableList.builder().add((Object)Pair.of((Object)RedirectUtils.repoPattern(oldKey, oldSlug), (Object)RedirectUtils.repoPattern(newKey, newSlug))).add((Object)Pair.of((Object)RedirectUtils.simplePattern(oldKey, oldSlug), (Object)RedirectUtils.simplePattern(newKey, newSlug))).build();
    }

    private static String getRequestUri(HttpServletRequest request) {
        Object uri = request.getAttribute("bbs.raw.request.uri");
        if (uri instanceof String) {
            return (String)uri;
        }
        return request.getRequestURI();
    }

    private static boolean isBoundary(String uri, int index) {
        if (index < 0 || index >= uri.length()) {
            return true;
        }
        char c = uri.charAt(index);
        return c == '/' || c == '#' || c == '?' || c == '&' || c == '=';
    }

    private static Optional<String> maybeReplace(String uri, List<Pair<String, String>> mappings) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return Optional.empty();
        }
        for (Pair<String, String> mapping : mappings) {
            int index = 0;
            String oldPatternLower = StringUtils.lowerCase((String)((String)mapping.getLeft()));
            String newPattern = (String)mapping.getRight();
            String uriLower = StringUtils.lowerCase((String)uri);
            while (index != -1) {
                if ((index = uriLower.indexOf(oldPatternLower, index)) < 0) continue;
                int endIndex = index + oldPatternLower.length();
                if (RedirectUtils.isBoundary(uri, index - 1) && RedirectUtils.isBoundary(uri, endIndex)) {
                    return Optional.of(uri.substring(0, index) + newPattern + uri.substring(endIndex));
                }
                index = endIndex;
            }
        }
        return Optional.empty();
    }

    private static String repoPattern(String key, String slug) {
        if (key.startsWith("~")) {
            return "users/" + key.replace("~", "") + "/repos/" + slug;
        }
        return "projects/" + key + "/repos/" + slug;
    }

    private static String simplePattern(String key, String slug) {
        return key + "/" + slug;
    }
}

