/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.WillNotClose;

public class IoUtils {
    public static long copy(File in, File out) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(out);){
            long l = IoUtils.copy(in, (OutputStream)outputStream);
            return l;
        }
    }

    public static long copy(File in, @WillNotClose OutputStream outputStream) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(in);){
            long l = IoUtils.copy((InputStream)inputStream, outputStream);
            return l;
        }
    }

    public static long copy(@WillNotClose InputStream inputStream, File out) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(out);){
            long l = IoUtils.copy(inputStream, (OutputStream)outputStream);
            return l;
        }
    }

    public static long copy(@WillNotClose InputStream inputStream, @WillNotClose OutputStream outputStream) throws IOException {
        return IoUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copy(@WillNotClose InputStream inputStream, @WillNotClose OutputStream outputStream, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        long total = 0L;
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
            total += (long)read;
        }
        return total;
    }
}

