/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.primitives.Ints;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AttachmentUri {
    public static final Pattern PATTERN = Pattern.compile("attachment:(\\d+)/([\\w\\-.*_+%]+)");
    private final int repositoryId;
    private final String attachmentId;

    public AttachmentUri(int repositoryId, String attachmentId) {
        this.repositoryId = repositoryId;
        this.attachmentId = attachmentId;
    }

    @Nullable
    public static AttachmentUri from(MatchResult matchResult) {
        String repositoryIdString = matchResult.group(1);
        String encodedAttachmentId = matchResult.group(2);
        Integer repositoryId = Ints.tryParse((String)repositoryIdString);
        if (repositoryId == null) {
            return null;
        }
        String attachmentId = UrlUtils.decodeURL(encodedAttachmentId);
        return new AttachmentUri(repositoryId, attachmentId);
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String toString() {
        String encodedAttachmentId = UrlUtils.encodeURL(this.attachmentId);
        return "attachment:" + this.repositoryId + "/" + encodedAttachmentId;
    }
}

