/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Pattern FORMULA_PATTERN = Pattern.compile("[\\d+\\-*/()\\s.]+");
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Properties load(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
    }

    @Deprecated
    @Nonnull
    public static Properties loadFromFile(@Nonnull File file) throws IOException {
        Objects.requireNonNull(file, "file");
        Properties properties = new Properties();
        if (file.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                properties.load(reader);
            }
        }
        return properties;
    }

    @Nonnull
    public static Optional<Properties> loadIfPresent(@Nonnull Path path) throws IOException {
        try {
            return Optional.of(PropertiesUtils.load(path));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Optional.empty();
        }
    }

    public static void store(@Nonnull Properties properties, @Nonnull Path path) throws IOException {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(path, "path");
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            properties.store(writer, null);
        }
    }

    @Deprecated
    public static void writeToFile(@Nonnull Properties properties, @Nonnull File file) throws IOException {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(file, "file");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            properties.store(writer, null);
        }
    }

    @Deprecated
    @Nullable
    public static String getProperty(@Nonnull File file, @Nonnull String key) throws IOException {
        Properties props = PropertiesUtils.loadFromFile(file);
        return props.getProperty(key);
    }

    @Deprecated
    @Nonnull
    public static OptionalDouble parseExpressionAsDouble(@Nullable String expression) {
        return PropertiesUtils.parseExpression(expression, OptionalDouble::of, OptionalDouble::empty);
    }

    @Deprecated
    @Nonnull
    public static OptionalInt parseExpressionAsInt(@Nullable String expression) {
        OptionalLong longValue = PropertiesUtils.parseExpressionAsLong(expression);
        if (longValue.isPresent()) {
            return OptionalInt.of(Ints.saturatedCast((long)longValue.getAsLong()));
        }
        return OptionalInt.empty();
    }

    @Deprecated
    @Nonnull
    public static OptionalLong parseExpressionAsLong(@Nullable String expression) {
        return PropertiesUtils.parseExpression(expression, value -> OptionalLong.of(Math.round(value)), OptionalLong::empty);
    }

    @Nonnull
    private static <OV> OV parseExpression(@Nullable String expression, Function<Double, OV> toOptional, Supplier<OV> emptyOptional) {
        if (expression != null && FORMULA_PATTERN.matcher(expression = expression.toLowerCase().replace("cpu", Integer.toString(Runtime.getRuntime().availableProcessors()))).matches()) {
            try {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(expression, Double.TYPE, new String[0], new Class[0]);
                return toOptional.apply((Double)evaluator.evaluate(new Object[0]));
            }
            catch (CompileException e) {
                log.debug("Error while parsing expression " + expression, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug("Error while evaluating expression " + expression, (Throwable)e);
            }
        }
        return emptyOptional.get();
    }
}

