/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Chainable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;

    private Chainable(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Nonnull
    public static <T> Chainable<T> chain(@Nonnull Iterable<T> iterable) {
        return new Chainable<T>(Objects.requireNonNull(iterable, "iterable"));
    }

    @Nonnull
    public static <T> Chainable<T> chain(@Nonnull T[] elements) {
        return new Chainable<T>(Arrays.asList(Objects.requireNonNull(elements, "elements")));
    }

    @Nonnull
    public Chainable<T> filter(@Nonnull Predicate<? super T> predicate) {
        return Chainable.chain(Iterables.filter(this.iterable, predicate::test));
    }

    @Nullable
    public T getFirst() {
        return this.iterable.iterator().next();
    }

    @Nullable
    public T getFirst(@Nullable T defaultValue) {
        return (T)Iterables.getFirst(this.iterable, defaultValue);
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.iterable);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    @Nonnull
    public Chainable<T> limit(int size) {
        return Chainable.chain(Iterables.limit(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<List<T>> partition(int size) {
        return Chainable.chain(Iterables.partition(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<T> skip(int size) {
        return Chainable.chain(Iterables.skip(this.iterable, (int)size));
    }

    @Nonnull
    public Chainable<T> sort(@Nonnull Comparator<? super T> comparator) {
        Ordering ordering = Ordering.from(Objects.requireNonNull(comparator, "comparator"));
        return Chainable.chain(ordering.immutableSortedCopy(this.iterable));
    }

    @Nonnull
    public Set<T> toSet() {
        return ImmutableSet.copyOf(this.iterable);
    }

    @Nonnull
    public List<T> toList() {
        return ImmutableList.copyOf(this.iterable);
    }

    @Nonnull
    public <R> Chainable<R> transform(@Nonnull Function<? super T, ? extends R> function) {
        return Chainable.chain(Iterables.transform(this.iterable, function::apply));
    }

    @Nonnull
    public <R> Chainable<R> flatMap(@Nonnull Function<? super T, ? extends Iterable<? extends R>> function) {
        return Chainable.chain(Iterables.concat((Iterable)Iterables.transform(this.iterable, r -> (Iterable)function.apply(r))));
    }
}

