/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.ShaUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SortedShaSet {
    private static final Logger log = LoggerFactory.getLogger(SortedShaSet.class);
    private static final int INITIAL_SIZE = 8;
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    private int length;
    private String[] values = new String[8];

    public boolean add(@Nonnull String sha) {
        Preconditions.checkArgument((sha != null && !"".equals(sha) ? 1 : 0) != 0, (Object)"sha cannot be empty");
        int index = Arrays.binarySearch(this.values, 0, this.length, sha, ShaUtils::compare);
        if (index >= 0) {
            return false;
        }
        index ^= 0xFFFFFFFF;
        if (this.length == this.values.length) {
            int newCapacity = this.length + (this.length >> 1);
            if (newCapacity < 0) {
                if (this.length == Integer.MAX_VALUE) {
                    throw new IllegalStateException("Cannot grow the array beyond " + this.length + " elements");
                }
                newCapacity = Integer.MAX_VALUE;
            }
            log.trace("Increasing capacity from {} to {}", (Object)this.length, (Object)newCapacity);
            String[] expanded = new String[newCapacity];
            System.arraycopy(this.values, 0, expanded, 0, index);
            System.arraycopy(this.values, index, expanded, index + 1, this.length - index);
            this.values = expanded;
        } else if (index < this.length) {
            System.arraycopy(this.values, index, this.values, index + 1, this.length - index);
        }
        this.values[index] = sha;
        ++this.length;
        return true;
    }

    public boolean contains(@Nonnull String sha) {
        return !"".equals(sha) && Arrays.binarySearch(this.values, 0, this.length, sha, ShaUtils::compare) >= 0;
    }

    @Nonnull
    public String get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index " + i + " is out of bounds; size = " + this.length);
        }
        return this.values[i];
    }

    public int indexOf(@Nonnull String sha) {
        if ("".equals(sha)) {
            return -1;
        }
        return Math.max(-1, Arrays.binarySearch(this.values, 0, this.length, sha, ShaUtils::compare));
    }

    public boolean remove(@Nonnull String sha) {
        int i = Arrays.binarySearch(this.values, 0, this.length, sha, ShaUtils::compare);
        if (i < 0 || "".equals(sha)) {
            return false;
        }
        System.arraycopy(this.values, i + 1, this.values, i, this.length - 1 - i);
        this.values[this.length - 1] = null;
        --this.length;
        return true;
    }

    public int size() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedShaSet that = (SortedShaSet)o;
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.length && i < that.length; ++i) {
            if (ShaUtils.compare(this.values[i], that.values[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 31;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.values[i].charAt(0);
        }
        return result;
    }
}

